/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode;

import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.kubenode.KubeApiProvider;
import com.browsersoft.config.kubenode.configuration.KubeNodeConfiguration;
import io.kubernetes.client.Exec;
import io.kubernetes.client.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecService {
    private KubeNodeConfiguration kubeNodeConfiguration;
    private KubeApiProvider kubeApiProvider;
    private ConsoleWriter writer;

    public ExecService(KubeApiProvider kubeApiProvider, KubeNodeConfiguration kubeNodeConfiguration, ConsoleWriter writer) {
        this.kubeNodeConfiguration = kubeNodeConfiguration;
        this.kubeApiProvider = kubeApiProvider;
        this.writer = writer;
    }

    public byte[] exec(String podId, String[] cmd, boolean debug) throws Exception {
        Exec exec = new Exec();
        Process proc = exec.exec(this.kubeNodeConfiguration.getKubernetesConfiguration().getNamespace(), podId, cmd, false, false);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Thread out = new Thread(() -> {
            try {
                if (debug) {
                    this.writer.message("Exec Start", "info");
                }
                Streams.copy((InputStream)proc.getInputStream(), (OutputStream)outputStream);
                if (debug) {
                    this.writer.message("Exec OK", "info");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        out.start();
        if (debug) {
            this.writer.message("After start", "info");
        }
        proc.waitFor();
        if (debug) {
            this.writer.message("After waitFor", "info");
        }
        out.join();
        if (debug) {
            this.writer.message("After Join", "info");
        }
        proc.destroy();
        if (debug) {
            this.writer.message("After Destroy", "info");
        }
        return outputStream.toByteArray();
    }
}

