/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode;

import com.browsersoft.config.jgate.SocketGateNode;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.kubenode.KubeNodeAccessRuleResolver;
import com.browsersoft.config.kubenode.KubeNodeBaseService;
import com.browsersoft.config.kubenode.KubeNodeService;
import com.browsersoft.config.kubenode.configuration.KubeNodeConfiguration;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class KubeNode {
    private static final Logger log = LoggerFactory.getLogger(KubeNode.class);
    private KubeNodeConfiguration configuration;
    private KubeNodeAccessRuleResolver accessResolver;
    private KubeNodeBaseService baseService;
    private Object mainService;
    private SocketGateNode gate;

    public KubeNode(String configPath) throws Exception {
        this.init(configPath);
    }

    private void init(String configPath) throws Exception {
        boolean res;
        this.configuration = new KubeNodeConfiguration(configPath);
        File rootDir = this.configuration.getStorageRoot();
        if (!rootDir.exists() && !(res = rootDir.mkdirs())) {
            throw new Exception("Unable to create directory " + rootDir.getAbsolutePath());
        }
        this.baseService = new KubeNodeBaseService(this, rootDir);
        this.mainService = this.loadMainService(rootDir);
    }

    public void start() throws Exception {
        this.startGate();
    }

    private void startGate() throws Exception {
        if (this.gate != null) {
            throw new Exception("KubeNode is already running!");
        }
        this.registerSignalHandler();
        GateNodeConfiguration gateNodeConfiguration = new GateNodeConfiguration();
        gateNodeConfiguration.addInt("CLIENT_CALLING_TIMEOUT", 10000);
        this.accessResolver = new KubeNodeAccessRuleResolver(this.configuration);
        this.gate = new SocketGateNode(gateNodeConfiguration);
        this.gate.registerService("base", (Object)this.baseService, "com.browsersoft.config.api.KubeNodeBaseServiceProxy");
        this.gate.setRuleResolverToService("base", (RuleResolver)this.accessResolver);
        if (this.mainService != null) {
            log.debug("Registering KubeNodeService");
            this.gate.registerService("service", this.mainService, "com.browsersoft.config.api.KubeNodeServiceProxy");
            this.gate.setRuleResolverToService("service", (RuleResolver)this.accessResolver);
        }
        this.gate.runAsServer(this.configuration.getGateServerConfiguration());
        log.info("************************************");
        log.info("Kube Node 1.0 started");
        log.info("************************************");
    }

    private Object loadMainService(File rootDir) throws Exception {
        return new KubeNodeService(rootDir, this.configuration);
    }

    boolean hasMainService() {
        return this.mainService != null;
    }

    public void stop() {
        if (this.gate != null) {
            this.gate.closeAllReceivers();
            this.gate = null;
        }
    }

    private void registerSignalHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            log.info("Missing required config-path parameter!");
            System.exit(1);
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        KubeNode kubeNode = new KubeNode(args[0]);
        kubeNode.start();
    }
}

