/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode;

import com.browsersoft.config.api.Deployment;
import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.FileInfo;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.Solution;
import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.api.UserInfoProvider;
import com.browsersoft.config.api.WorldBindingUtils;
import com.browsersoft.config.api.appinfo.Jar;
import com.browsersoft.config.api.cloud.KubeEntityInfo;
import com.browsersoft.config.api.cloud.KubeEntityInfoType;
import com.browsersoft.config.api.cloud.KubeEvent;
import com.browsersoft.config.api.cloud.PodStatus;
import com.browsersoft.config.api.console.ConsoleReader;
import com.browsersoft.config.api.deployment.RunScriptMacroReplacer;
import com.browsersoft.config.api.hub.ConfigDir;
import com.browsersoft.config.api.hub.ContainerImageURL;
import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemFactory;
import com.browsersoft.config.api.system.OperatingSystemType;
import com.browsersoft.config.api.update.UpdateUtils;
import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.console.DefaultConsoleWriter;
import com.browsersoft.config.jgate.annotations.GateMethod;
import com.browsersoft.config.jgate.annotations.HandleProgress;
import com.browsersoft.config.jgate.exceptions.GateUserErrorException;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.kubenode.ExecService;
import com.browsersoft.config.kubenode.KubeApiProvider;
import com.browsersoft.config.kubenode.PodEngineRun;
import com.browsersoft.config.kubenode.configuration.DockerRegistryConfiguration;
import com.browsersoft.config.kubenode.configuration.KubeNodeConfiguration;
import com.browsersoft.config.kubenode.deploy.ApplyDeployStrategy;
import com.browsersoft.config.kubenode.deploy.DefaultDeployStrategy;
import com.browsersoft.config.kubenode.deploy.RedeployAllStrategy;
import com.browsersoft.config.kubenode.terminals.PodTerminals;
import com.browsersoft.config.kubenode.utils.AssetsUtils;
import com.browsersoft.config.s3cli.AesAwsS3Storage;
import com.browsersoft.config.s3cli.ObjectStorage;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.StreamUtils;
import com.browsersoft.config.utils.ZipUtil;
import com.browsersoft.config.utils.streams.SizedInputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.kubernetes.client.Copy;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.apis.StorageV1Api;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.openapi.models.V1PersistentVolumeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1PodStatus;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetList;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1Status;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeNodeService
implements KubeApiProvider {
    private static final Logger log = LoggerFactory.getLogger(KubeNodeService.class);
    private static final String ROOT_PATH = "/opt/hie-engine/root";
    private static final String PERSISTENCE_ROOT_PATH = "/opt/hie-engine/persistent_root/";
    private final File rootDir;
    private KubeNodeConfiguration configuration;
    private ConsoleWriter consoleWriter;
    private ConsoleReader consoleReader;
    private ExecService execService;
    private PodTerminals podTerminals;
    private boolean updating;
    private final ReentrantLock deploymentLock = new ReentrantLock();

    public KubeNodeService(File rootDir, KubeNodeConfiguration configuration) throws Exception {
        this.rootDir = rootDir;
        this.configuration = configuration;
        FileUtils.ensureDirectory((File)configuration.getConsoleRoot());
        this.consoleWriter = new DefaultConsoleWriter(configuration.getConsoleRoot(), "console");
        this.consoleReader = new ConsoleReader(configuration.getConsoleRoot());
        this.consoleWriter.message("************************************", "info");
        this.consoleWriter.message("Kube Node 1.0 started", "info");
        this.consoleWriter.message("************************************", "info");
        this.execService = new ExecService(this, configuration, this.consoleWriter);
        this.podTerminals = new PodTerminals();
    }

    @GateMethod
    public List<KubeEvent> getEvents() throws Exception {
        ApiClient client = this.getApi();
        CoreV1Api api = new CoreV1Api(client);
        CoreV1EventList eventList = api.listNamespacedEvent(this.configuration.getKubernetesConfiguration().getNamespace(), "no_pretty", null, null, null, null, Integer.valueOf(300), null, null, Integer.valueOf(30), Boolean.valueOf(false));
        ArrayList<KubeEvent> ret = new ArrayList<KubeEvent>();
        for (CoreV1Event event : eventList.getItems()) {
            long epochMilli = 0L;
            if (event.getLastTimestamp() != null) {
                epochMilli = event.getLastTimestamp().toInstant().toEpochMilli();
            } else if (event.getFirstTimestamp() != null) {
                epochMilli = event.getFirstTimestamp().toInstant().toEpochMilli();
            }
            Date date = new Date(epochMilli);
            ret.add(new KubeEvent(date, event.getMetadata().getName(), event.getReason(), event.getMessage()));
        }
        Collections.sort(ret, new Comparator<KubeEvent>(){

            @Override
            public int compare(KubeEvent o1, KubeEvent o2) {
                int ret = o1.getDate().compareTo(o2.getDate());
                if (ret == 0) {
                    return o1.getMessage().compareTo(o2.getMessage());
                }
                return ret;
            }
        });
        return ret;
    }

    @GateMethod
    @HandleProgress
    public Boolean deploySolution(Solution solution, String type, UserInfo userInfo, ServiceCallMethodHandler handler) throws Exception {
        try {
            DefaultDeployStrategy strategy;
            String hardCodedRelease;
            DockerRegistryConfiguration registryConfiguration;
            String fileName;
            boolean lockOk = this.deploymentLock.tryLock();
            if (!lockOk) {
                throw new Exception("Another deploying already in progress");
            }
            handler.callingMethodInProgress(0, "Deployment initialization");
            this.consoleWriter.message("--------------------", "info");
            this.consoleWriter.message("Deploying Solution " + solution.getName(), "info");
            this.consoleWriter.message("--------------------", "info");
            String uuid = UUID.randomUUID().toString();
            File temp = FileUtils.ensureDirectory((File)this.configuration.getStorageRoot(), (String[])new String[]{"temp/" + uuid});
            this.consoleWriter.message("Using Temp File " + temp.getAbsolutePath(), "info");
            HashMap<String, String> fileReplaces = new HashMap<String, String>();
            AesAwsS3Storage s3 = this.configuration.getS3Configuration().getStorage();
            String jarsTxt = null;
            String classPathTxt = null;
            String jarsBucket = this.configuration.getClientId();
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            if (this.configuration.isDevelMode()) {
                handler.callingMethodInProgress(20, "Deploying engine jar files");
                StringBuilder classPathBuilder = new StringBuilder();
                Iterator jars = solution.getJars();
                Iterator iterator = jars.iterator();
                while (iterator.hasNext()) {
                    JarRecord jar = (JarRecord)iterator.next();
                    fileName = "jars/" + jar.toCacheName() + ".jar";
                    if (!s3.objectExist(jarsBucket, fileName)) {
                        File file = this.configuration.getJarStorage().get((TransferableFileInfo)jar);
                        this.consoleWriter.message("Uploading jar to S3: " + fileName, "info");
                        this.uploadToS3((ObjectStorage)s3, jarsBucket, fileName, file);
                        this.consoleWriter.message("OK", "info");
                    }
                    if (!first) {
                        builder.append("\n");
                        classPathBuilder.append(":");
                    }
                    builder.append("../lib/").append(jar.getName()).append("#").append(jar.toCacheName()).append(".jar");
                    classPathBuilder.append("../lib/").append(jar.getName());
                    first = false;
                }
                classPathTxt = classPathBuilder.toString();
            }
            OperatingSystem operatingSystem = OperatingSystemFactory.getOperatingSystem((OperatingSystemType)OperatingSystemType.Unix);
            handler.callingMethodInProgress(40, "Deploying control interface jar files");
            for (Jar jar : operatingSystem.getApiJars()) {
                String cacheName = jar.getName() + "-" + jar.getHash();
                fileName = "jars/" + cacheName + ".jar";
                if (!s3.objectExist(jarsBucket, fileName)) {
                    operatingSystem.copyJar(temp, jar.getName());
                    this.consoleWriter.message("Uploading control jar to S3: " + fileName, "info");
                    this.uploadToS3((ObjectStorage)s3, jarsBucket, fileName, new File(temp, jar.getName()));
                    this.consoleWriter.message("OK", "info");
                }
                if (!first) {
                    builder.append("\n");
                }
                builder.append("./engine_control/" + jar.getName()).append("#").append(cacheName).append(".jar");
                first = false;
            }
            jarsTxt = builder.toString();
            handler.callingMethodInProgress(60, "Deploying configuration packages");
            for (Deployment deployment : solution.getDeployments()) {
                this.consoleWriter.message("Solving deployment: " + deployment.getId(), "info");
                deployment.setProfile(deployment.getProfile().replace("#KUBE_NAMESPACE#", this.configuration.getKubernetesConfiguration().getNamespace()));
                String deploymentId = deployment.getName().toLowerCase();
                File deploymentDir = FileUtils.ensureDirectory((File)temp, (String[])new String[]{deploymentId});
                WorldBindingUtils.deployDeploymentToFolder((File)deploymentDir, (Deployment)deployment, (TransferableFileStorage)this.configuration.getDirStorage(), (boolean)false);
                File jarsFile = new File(deploymentDir, "jars.txt");
                FileUtils.saveBytesToFile((File)jarsFile, (byte[])jarsTxt.getBytes("UTF-8"));
                if (classPathTxt != null) {
                    File classPathFile = new File(deploymentDir, "classpath.txt");
                    FileUtils.saveBytesToFile((File)classPathFile, (byte[])classPathTxt.getBytes("UTF-8"));
                }
                String dirsBucket = this.configuration.getClientId();
                StringBuilder uniqueDirsString = new StringBuilder();
                for (ConfigDir configDir : deployment.getDirs()) {
                    String fileName2 = "dirs/" + configDir.toCacheName() + ".zip";
                    if (!s3.objectExist(dirsBucket, fileName2)) {
                        File file = this.configuration.getDirStorage().get((TransferableFileInfo)configDir);
                        this.consoleWriter.message("Uploading dir to S3: " + fileName2, "info");
                        this.uploadToS3((ObjectStorage)s3, jarsBucket, fileName2, file);
                        this.consoleWriter.message("OK", "info");
                    }
                    uniqueDirsString.append(configDir.toCacheName()).append("#");
                }
                this.createHieEngineScript(deploymentDir, operatingSystem);
                this.createRunScript(deployment, deploymentDir);
                EngineGround engineGround = new EngineGround();
                engineGround.setName(deploymentId);
                engineGround.setEngineId("PROJECT_ID");
                engineGround.setPort(9876);
                engineGround.setReleaseName(solution.getReleaseName());
                engineGround.setUserInfo(UserInfoProvider.getUserInfo());
                engineGround.setDeployed(new Date());
                FileUtils.saveBytesToFile((File)new File(deploymentDir, "engine.xml"), (byte[])engineGround.saveToXml().getBytes("UTF-8"));
                Object unique = deploymentId + "#" + deployment.getReleaseName() + "#" + KubeNodeService.hash(deployment.getConfig()) + "#" + KubeNodeService.hash(deployment.getProfile()) + "#" + jarsTxt + "#" + uniqueDirsString.toString();
                unique = KubeNodeService.hash((String)unique);
                String zipName = "D" + (String)unique + "-" + deploymentId + ".zip";
                this.consoleWriter.message("Zip name :" + zipName, "info");
                File outFile = new File(temp, zipName);
                ZipUtil.zipFolder((File)deploymentDir, (File)outFile);
                fileReplaces.put(deploymentId, outFile.getName());
                FileUtils.deleteDir((File)deploymentDir);
                String file = "deployments/" + outFile.getName();
                if (!s3.objectExist(dirsBucket, file)) {
                    this.consoleWriter.message("Uploading to S3:" + file, "info");
                    this.uploadToS3((ObjectStorage)s3, jarsBucket, file, outFile);
                    this.consoleWriter.message("OK", "info");
                    continue;
                }
                this.consoleWriter.message(file + " is already in S3", "info");
            }
            s3.close();
            FileUtils.deleteDir((File)temp);
            handler.callingMethodInProgress(80, "Deploying kubernetes configuration");
            ApiClient client = this.getApi();
            ContainerImageURL containerImageURL = solution.getContainerImageURL();
            if (containerImageURL == null) {
                containerImageURL = new ContainerImageURL();
                containerImageURL.setTag(solution.getReleaseName());
            }
            if (!(registryConfiguration = this.configuration.getDockerRegistryConfiguration()).getUrl().isEmpty()) {
                containerImageURL.setRegistryUrl(registryConfiguration.getUrl());
            }
            if (!(hardCodedRelease = registryConfiguration.getHardCodedRelease()).isEmpty()) {
                if (hardCodedRelease.contains(":")) {
                    String[] strs = hardCodedRelease.split(":");
                    if (strs.length != 2) {
                        throw new Exception("Invalid hard code image configuration");
                    }
                    containerImageURL.setRepository(strs[0]);
                    containerImageURL.setTag(strs[1]);
                } else {
                    containerImageURL.setRepository(hardCodedRelease);
                }
            }
            String imageId = containerImageURL.toString();
            this.consoleWriter.message("Using image:" + imageId, "info");
            Object yaml = solution.getYaml();
            yaml = ((String)yaml).replace("#IMAGE#", imageId);
            yaml = ((String)yaml).replace("#S3_STORAGE_URL#", this.configuration.getS3Configuration().getS3CliConfiguration().getUrl());
            yaml = ((String)yaml).replace("#S3_STORAGE_ACCESS_KEY#", Base64.getEncoder().encodeToString(this.configuration.getS3Configuration().getS3CliConfiguration().getKey().getBytes("UTF-8")));
            yaml = ((String)yaml).replace("#S3_STORAGE_SECRET_KEY#", Base64.getEncoder().encodeToString(this.configuration.getS3Configuration().getS3CliConfiguration().getSecret().getBytes("UTF-8")));
            yaml = ((String)yaml).replace("#S3_STORAGE_REGION#", this.configuration.getS3Configuration().getS3CliConfiguration().getRegion());
            yaml = ((String)yaml).replace("#S3_STORAGE_BUCKET#", this.configuration.getClientId());
            yaml = ((String)yaml).replace("#S3_STORAGE_AES_PASSWORD#", Base64.getEncoder().encodeToString(this.configuration.getS3Configuration().getAesPassword().getBytes("UTF-8")));
            yaml = ((String)yaml).replace("#STORAGE_CLASS_NAME#", this.configuration.getKubernetesConfiguration().getStorageClassName());
            for (Map.Entry entry : fileReplaces.entrySet()) {
                yaml = ((String)yaml).replace("#" + ((String)entry.getKey()).toLowerCase() + "_STORAGE_PATH#", (CharSequence)entry.getValue());
            }
            yaml = registryConfiguration.getSecretYaml(imageId) + "\n---\n" + (String)yaml;
            this.consoleWriter.message("--------------------", "info");
            this.consoleWriter.message("Final Yaml", "info");
            this.consoleWriter.message("--------------------", "info");
            this.consoleWriter.message((String)yaml, "info");
            if (type.equals("Update")) {
                strategy = new ApplyDeployStrategy();
            } else if (type.equals("Reinstall")) {
                strategy = new RedeployAllStrategy();
            } else {
                throw new Exception("Unknown strategy: " + type);
            }
            strategy.deploy(client, (String)yaml, this.configuration, this.consoleWriter);
            handler.callingMethodInProgress(100, "Finished");
        }
        catch (ApiException e) {
            this.handleException((Exception)((Object)e));
            String message = this.getApiExceptionMessage(e);
            throw new GateUserErrorException(message);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
        finally {
            this.deploymentLock.unlock();
        }
        return true;
    }

    private String getApiExceptionMessage(ApiException e) {
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(e.getResponseBody());
            JsonObject jsonObj = json.getAsJsonObject();
            String kind = jsonObj.get("kind").getAsString();
            String status = jsonObj.get("status").getAsString();
            String message = jsonObj.get("message").getAsString();
            if ("Status".equals(kind) && "Failure".equals(status) && message != null && !message.isEmpty()) {
                return message;
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(json);
        }
        catch (Exception ee) {
            return e.getCode() + ":" + e.getResponseBody();
        }
    }

    private void handleException(Exception e) {
        this.consoleWriter.message("ERROR:", "error");
        if (e instanceof ApiException) {
            ApiException apiException = (ApiException)((Object)e);
            try {
                JsonParser parser = new JsonParser();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonElement el = parser.parse(apiException.getResponseBody());
                String formatted = gson.toJson(el);
                this.consoleWriter.message(formatted, "error");
            }
            catch (Exception ee) {
                this.consoleWriter.message(apiException.getCode() + ":" + apiException.getResponseBody(), "error");
            }
        }
        this.consoleWriter.message(StreamUtils.getExceptionStack((Throwable)e), "error");
    }

    private void uploadToS3(ObjectStorage s3, String bucket, String fileName, File file) throws Exception {
        s3.uploadObject(bucket, fileName, FileUtils.loadFileToBytes((File)file));
    }

    @GateMethod
    public void uploadDir(ConfigDir configDir, SizedInputStream inputStream) throws Exception {
        this.configuration.getDirStorage().put((TransferableFileInfo)configDir, (InputStream)inputStream, null);
    }

    @GateMethod
    public void uploadJar(JarRecord jarRecord, SizedInputStream inputStream) throws Exception {
        this.configuration.getJarStorage().put((TransferableFileInfo)jarRecord, (InputStream)inputStream, null);
    }

    @GateMethod
    public boolean isUsingJarsEnabled() throws Exception {
        return this.configuration.isDevelMode();
    }

    @GateMethod
    public List<JarRecord> getMissingJars(List<JarRecord> records) throws Exception {
        return this.configuration.getJarStorage().filter(records);
    }

    @GateMethod
    public List<ConfigDir> getMissingFolders(List<ConfigDir> folders) throws Exception {
        return this.configuration.getDirStorage().filter(folders);
    }

    @GateMethod
    public String checkApi() throws Exception {
        try {
            CoreV1Api api = this.getCoreApi();
            api.listNamespacedPod(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, Integer.valueOf(1000), null, null, Integer.valueOf(1000), null);
            return "ok";
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public String exec(String pod, String[] command) throws Exception {
        try {
            return new String(this.execService.exec(pod, command, false), "UTF-8");
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public String newTerminal(String pod) throws Exception {
        try {
            return this.podTerminals.newTerminal(this.configuration.getKubernetesConfiguration().getNamespace(), pod);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public byte[] readTerminal(String uuid) throws Exception {
        try {
            return this.podTerminals.read(uuid);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void writeTerminal(String uuid, byte[] bytes) throws Exception {
        try {
            this.podTerminals.write(uuid, bytes);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void closeTerminal(String uuid) throws Exception {
        try {
            this.podTerminals.close(uuid);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public String getDetailsOfKubeEntity(KubeEntityInfo kubeEntityInfo) throws Exception {
        try {
            ApiClient client = this.getApi();
            CoreV1Api api = new CoreV1Api(client);
            AppsV1Api appsV1Api = new AppsV1Api(client);
            NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
            switch (kubeEntityInfo.getType()) {
                case DEPLOYMENT: {
                    return client.getJSON().serialize((Object)appsV1Api.readNamespacedDeployment(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null));
                }
                case STATEFULSET: {
                    return client.getJSON().serialize((Object)appsV1Api.readNamespacedStatefulSet(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null));
                }
                case SERVICE: {
                    return api.readNamespacedService(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null).toString();
                }
                case INGRESS: {
                    return networkingV1Api.readNamespacedIngress(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null).toString();
                }
                case SECRET: {
                    return api.readNamespacedSecret(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null).toString();
                }
                case POD: {
                    return api.readNamespacedPod(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null).toString();
                }
                case PERSISTENT_VOLUME: {
                    return api.readPersistentVolume(kubeEntityInfo.getId(), null).toString();
                }
                case PERSISTENT_VOLUME_CLAIM: {
                    return api.readNamespacedPersistentVolumeClaim(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null).toString();
                }
            }
            return "";
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public List<KubeEntityInfo> getKubeEntities() throws Exception {
        try {
            ApiClient client = this.getApi();
            CoreV1Api api = new CoreV1Api(client);
            AppsV1Api appsV1Api = new AppsV1Api(client);
            NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
            ArrayList<KubeEntityInfo> ret = new ArrayList<KubeEntityInfo>();
            try {
                V1IngressList v1IngressList = networkingV1Api.listNamespacedIngress(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
                for (V1Ingress ingress : v1IngressList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)ingress, KubeEntityInfoType.INGRESS);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'ingress' entities", (Throwable)e);
            }
            try {
                V1SecretList secretList = api.listNamespacedSecret(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
                for (V1Secret secret : secretList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)secret, KubeEntityInfoType.SECRET);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'secret' entities", (Throwable)e);
            }
            try {
                V1ServiceList serviceList = api.listNamespacedService(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
                for (V1Service service : serviceList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)service, KubeEntityInfoType.SERVICE);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'service' entities", (Throwable)e);
            }
            try {
                V1DeploymentList deploymentList = appsV1Api.listNamespacedDeployment(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
                for (V1Deployment deployment : deploymentList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)deployment, KubeEntityInfoType.DEPLOYMENT);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'deployment' entities", (Throwable)e);
            }
            try {
                V1StatefulSetList statefulSetList = appsV1Api.listNamespacedStatefulSet(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
                for (V1Deployment deployment : statefulSetList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)deployment, KubeEntityInfoType.STATEFULSET);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'statefulSet' entities", (Throwable)e);
            }
            try {
                V1PersistentVolumeList v1PersistentVolumeList = api.listPersistentVolume(null, null, null, null, null, null, null, null, null, null);
                for (V1PersistentVolume volume : v1PersistentVolumeList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)volume, KubeEntityInfoType.PERSISTENT_VOLUME);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'persistentVolume' entities", (Throwable)e);
            }
            try {
                V1PersistentVolumeClaimList v1PersistentVolumeClaimList = api.listNamespacedPersistentVolumeClaim(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
                for (V1PersistentVolumeClaim claim : v1PersistentVolumeClaimList.getItems()) {
                    this.addEntity(ret, (KubernetesObject)claim, KubeEntityInfoType.PERSISTENT_VOLUME_CLAIM);
                }
            }
            catch (ApiException e) {
                log.warn("Unable to load 'persistentVolumeClaim' entities", (Throwable)e);
            }
            return ret;
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void stopAll() throws Exception {
        try {
            ApiClient client = this.getApi();
            CoreV1Api api = new CoreV1Api(client);
            AppsV1Api appsV1Api = new AppsV1Api(client);
            V1DeploymentList deploymentList = appsV1Api.listNamespacedDeployment(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (V1Deployment deployment : deploymentList.getItems()) {
                V1DeploymentSpec newSpec = deployment.getSpec().replicas(Integer.valueOf(0));
                V1Deployment newDeploy = deployment.spec(newSpec);
                appsV1Api.replaceNamespacedDeployment(deployment.getMetadata().getName(), this.configuration.getKubernetesConfiguration().getNamespace(), newDeploy, null, null, null, null);
            }
            V1StatefulSetList statefulSetList = appsV1Api.listNamespacedStatefulSet(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (V1StatefulSet deployment : statefulSetList.getItems()) {
                V1StatefulSetSpec newSpec = deployment.getSpec().replicas(Integer.valueOf(0));
                V1StatefulSet newDeploy = deployment.spec(newSpec);
                appsV1Api.replaceNamespacedStatefulSet(deployment.getMetadata().getName(), this.configuration.getKubernetesConfiguration().getNamespace(), newDeploy, null, null, null, null);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void runAll() throws Exception {
        try {
            ApiClient client = this.getApi();
            CoreV1Api api = new CoreV1Api(client);
            AppsV1Api appsV1Api = new AppsV1Api(client);
            V1DeploymentList deploymentList = appsV1Api.listNamespacedDeployment(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (V1Deployment deployment : deploymentList.getItems()) {
                String replicas = (String)deployment.getMetadata().getLabels().get("rc_label");
                int originalReplicas = Integer.parseInt(replicas.replace("replicas_", ""));
                V1DeploymentSpec newSpec = deployment.getSpec().replicas(Integer.valueOf(originalReplicas));
                V1Deployment newDeploy = deployment.spec(newSpec);
                appsV1Api.replaceNamespacedDeployment(deployment.getMetadata().getName(), this.configuration.getKubernetesConfiguration().getNamespace(), newDeploy, null, null, null, null);
            }
            V1StatefulSetList statefulSetList = appsV1Api.listNamespacedStatefulSet(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (V1StatefulSet deployment : statefulSetList.getItems()) {
                String replicas = (String)deployment.getMetadata().getLabels().get("rc_label");
                int originalReplicas = Integer.parseInt(replicas.replace("replicas_", ""));
                V1StatefulSetSpec newSpec = deployment.getSpec().replicas(Integer.valueOf(originalReplicas));
                V1StatefulSet newDeploy = deployment.spec(newSpec);
                appsV1Api.replaceNamespacedStatefulSet(deployment.getMetadata().getName(), this.configuration.getKubernetesConfiguration().getNamespace(), newDeploy, null, null, null, null);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void restartAll() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    KubeNodeService.this.stopAll();
                    for (int waitAttempts = 20; KubeNodeService.this.getPods().size() > 0 || waitAttempts != 0; --waitAttempts) {
                        Thread.sleep(1000L);
                    }
                    KubeNodeService.this.runAll();
                }
                catch (Exception e) {
                    KubeNodeService.this.handleException(e);
                }
            }
        }).start();
    }

    @GateMethod
    public void deleteEntity(KubeEntityInfo kubeEntityInfo) throws Exception {
        try {
            ApiClient client = this.getApi();
            CoreV1Api api = new CoreV1Api(client);
            AppsV1Api appsV1Api = new AppsV1Api(client);
            NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
            StorageV1Api storageV1Api = new StorageV1Api(client);
            switch (kubeEntityInfo.getType()) {
                case STATEFULSET: {
                    this.consoleWriter.message("Deleting statefullset " + kubeEntityInfo.getId() + " ...", "info");
                    V1Status status = appsV1Api.deleteNamespacedStatefulSet(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                    break;
                }
                case DEPLOYMENT: {
                    this.consoleWriter.message("Deleting deployment " + kubeEntityInfo.getId() + " ...", "info");
                    V1Status status = appsV1Api.deleteNamespacedDeployment(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                    break;
                }
                case INGRESS: {
                    this.consoleWriter.message("Deleting ingress " + kubeEntityInfo.getId() + " ...", "info");
                    V1Status status = networkingV1Api.deleteNamespacedIngress(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                    break;
                }
                case SECRET: {
                    this.consoleWriter.message("Deleting secret " + kubeEntityInfo.getId() + " ...", "info");
                    V1Status status = api.deleteNamespacedSecret(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                    break;
                }
                case SERVICE: {
                    this.consoleWriter.message("Deleting service " + kubeEntityInfo.getId() + " ...", "info");
                    api.deleteNamespacedService(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                    break;
                }
                case PERSISTENT_VOLUME: {
                    this.consoleWriter.message("Deleting volume " + kubeEntityInfo.getId() + " ...", "info");
                    api.deletePersistentVolume(kubeEntityInfo.getId(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                    break;
                }
                case PERSISTENT_VOLUME_CLAIM: {
                    this.consoleWriter.message("Deleting volume claim " + kubeEntityInfo.getId() + " ...", "info");
                    api.deleteNamespacedPersistentVolumeClaim(kubeEntityInfo.getId(), this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, null);
                    this.consoleWriter.message("OK", "info");
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    private void addEntity(List<KubeEntityInfo> ret, KubernetesObject object, KubeEntityInfoType service1) {
        String name = "";
        if (object.getMetadata() != null) {
            name = object.getMetadata().getName();
        }
        ret.add(new KubeEntityInfo(name, service1));
    }

    @GateMethod
    public List<KubeEntityInfo> getPods() throws Exception {
        try {
            CoreV1Api api = this.getCoreApi();
            V1PodList l = api.listNamespacedPod(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, Integer.valueOf(1000), null, null, Integer.valueOf(1000), null);
            ArrayList<KubeEntityInfo> ret = new ArrayList<KubeEntityInfo>();
            for (V1Pod item : l.getItems()) {
                this.addEntity(ret, (KubernetesObject)item, KubeEntityInfoType.POD);
            }
            return ret;
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public List<PodStatus> getStatusOfPods() throws Exception {
        try {
            CoreV1Api api = this.getCoreApi();
            V1PodList l = api.listNamespacedPod(this.configuration.getKubernetesConfiguration().getNamespace(), null, null, null, null, null, Integer.valueOf(1000), null, null, Integer.valueOf(1000), null);
            ArrayList<PodStatus> podStatuses = new ArrayList<PodStatus>();
            ArrayList ret = new ArrayList();
            for (V1Pod item : l.getItems()) {
                V1PodStatus status = item.getStatus();
                PodStatus podStatus = new PodStatus();
                podStatus.setPodName(item.getMetadata().getName());
                podStatus.setPhase(status.getPhase());
                if (status.getConditions() != null) {
                    for (V1PodCondition condition : status.getConditions()) {
                        if (condition.getType() == null || condition.getReason() == null || !condition.getType().equals("PodScheduled") || !condition.getReason().equals("Unschedulable")) continue;
                        podStatus.setError(condition.getReason() + ": " + condition.getMessage());
                    }
                }
                PodEngineRun run = this.getRun(item.getMetadata().getName());
                podStatus.setProgress(run.getProgress());
                podStatuses.add(podStatus);
            }
            return podStatuses;
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public List<FileInfo> listFiles(String podId, String path) throws Exception {
        try {
            String[] cmd = new String[]{"./opt/hie-engine/root/hieengine.sh", "list", path};
            byte[] bytes = this.execService.exec(podId, cmd, false);
            String s = new String(bytes, "UTF-8");
            List<FileInfo> fileInfos = KubeNodeService.parseFiles(s);
            for (FileInfo fileInfo : fileInfos) {
                fileInfo.setAbsolutePath(new File(path, fileInfo.getName()).getAbsolutePath());
            }
            return fileInfos;
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void deleteFile(String podId, FileInfo fileInfo) throws Exception {
        try {
            String[] cmd = new String[]{"rm", "-r", fileInfo.getAbsolutePath()};
            byte[] byArray = this.execService.exec(podId, cmd, false);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void newFolderOnPod(String podId, String path) throws Exception {
        try {
            String[] cmd = new String[]{"mkdir", path};
            byte[] byArray = this.execService.exec(podId, cmd, false);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public SizedInputStream readPodFile(String podId, String path) throws Exception {
        try {
            Copy copy = new Copy(this.getApi());
            File tempFile = new File(FileUtils.createTempDir(), UUID.randomUUID().toString());
            tempFile.deleteOnExit();
            InputStream inputStream = copy.copyFileFromPod(this.configuration.getKubernetesConfiguration().getNamespace(), podId, path);
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            StreamUtils.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return new SizedInputStream(tempFile);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void writePodFile(String podId, String path, SizedInputStream inputStream) throws Exception {
        try {
            File tempFile = new File(FileUtils.createTempDir(), UUID.randomUUID().toString());
            tempFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            StreamUtils.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            Copy copy = new Copy(this.getApi());
            copy.copyFileToPodAsync(this.configuration.getKubernetesConfiguration().getNamespace(), podId, null, Paths.get(tempFile.getAbsolutePath(), new String[0]), Paths.get(path, new String[0]));
            tempFile.delete();
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    public static List<FileInfo> parseFiles(String s) {
        ArrayList<FileInfo> ret = new ArrayList<FileInfo>();
        Scanner scanner = new Scanner(s);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] items = line.split("#&&#", -1);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFolder(items[0].equals("Y"));
            fileInfo.setSize(Long.parseLong(items[1]));
            fileInfo.setDate(Long.parseLong(items[2]));
            fileInfo.setName(items[3]);
            ret.add(fileInfo);
        }
        scanner.close();
        return ret;
    }

    @GateMethod
    public void stopPod(String podId, UserInfo userInfo) throws Exception {
        try {
            this.getRun(podId).stopEngine(userInfo);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public EngineProcessState getState(String podId) throws Exception {
        try {
            return this.getRun(podId).getState();
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void killEngine(String podId, UserInfo userInfo) throws Exception {
        try {
            this.getRun(podId).killEngine();
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public void restartLogger(String podId, UserInfo userInfo) throws Exception {
        try {
            this.getRun(podId).restartLogger(userInfo);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public byte[] handleStepRequest(String boxId, byte[] o, String podId) throws Exception {
        throw new Exception("Not supported");
    }

    @GateMethod
    public byte[] readFile(String podId, String name) throws Exception {
        try {
            return this.getRun(podId).readFile(name);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    private PodEngineRun getRun(String podId) throws Exception {
        return new PodEngineRun(this.execService, podId, this, this.consoleWriter, this.configuration);
    }

    @GateMethod
    public List<Message> readPodConsole(String podId, String lastMessageId) throws Exception {
        try {
            return this.getRun(podId).getConsole(lastMessageId);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public List<Message> readConsole(String lastMessageId) throws Exception {
        try {
            return this.consoleReader.getConsole(lastMessageId);
        }
        catch (Exception e) {
            this.handleException(e);
            throw e;
        }
    }

    @GateMethod
    public String getVersion() throws Exception {
        return "82";
    }

    @GateMethod
    public void startUpdateVersion() throws Exception {
        if (this.updating) {
            throw new Exception("Update in progress");
        }
        UpdateUtils.startUpdateVersion((File)this.configuration.getUpdatePath());
    }

    @GateMethod
    public void skipUpdateVersion() throws Exception {
        this.updating = false;
        UpdateUtils.skipUpdateVersion((File)this.configuration.getUpdatePath());
    }

    @GateMethod
    public void stopUpdateVersion(Map<String, String> files) throws Exception {
        UpdateUtils.stopUpdateVersion(files, (File)this.configuration.getUpdatePath(), (File)this.configuration.getNodeRoot(), (Logger)log);
    }

    @GateMethod
    public void uploadUpdateFile(String path, String hash, SizedInputStream inputStream) throws Exception {
        UpdateUtils.uploadUpdateFile((String)path, (String)hash, (SizedInputStream)inputStream, (File)this.configuration.getUpdatePath(), (Logger)log);
    }

    @GateMethod
    public long getJarSize(String name) throws Exception {
        return UpdateUtils.getJarSize((String)name, (File)this.configuration.getUpdatePath());
    }

    private void createHieEngineScript(File directory, OperatingSystem operatingSystem) throws Exception {
        String controlProcessCmd = operatingSystem.createEngineControlCommand(PERSISTENCE_ROOT_PATH);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("CONTROL_PROCESS_CMD", controlProcessCmd);
        String content = AssetsUtils.renderTemplate("hieengine.sh", data);
        if (content == null) {
            throw new Exception("Unable to find or process hieengine.sh template");
        }
        File file = new File(directory, "hieengine.sh");
        FileUtils.saveStringToFileWithEncoding((File)file, (String)content, (String)StandardCharsets.UTF_8.name());
    }

    private void createRunScript(Deployment deployment, File directory) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("JAVA_OPTS", deployment.getJavaOpts());
        String content = AssetsUtils.renderTemplate("run.sh", data);
        if (content == null) {
            throw new Exception("Unable to find or process run.sh template");
        }
        content = RunScriptMacroReplacer.replaceMacros((String)content, Map.of("%ROOT%", ROOT_PATH, "%PERSISTENCE_ROOT%", PERSISTENCE_ROOT_PATH));
        File file = new File(directory, "run.sh");
        FileUtils.saveStringToFileWithEncoding((File)file, (String)content, (String)StandardCharsets.UTF_8.name());
    }

    public static String hash(String data) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance("sha1");
        m.update(data.getBytes(), 0, data.length());
        byte[] hashBytes = m.digest();
        StringBuilder sb = new StringBuilder();
        for (byte hashByte : hashBytes) {
            sb.append(Integer.toString((hashByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private CoreV1Api getCoreApi() throws Exception {
        return new CoreV1Api(this.getApi());
    }

    @Override
    public ApiClient getApi() throws Exception {
        return this.configuration.getKubernetesConfiguration().getApi();
    }
}

