/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode;

import com.browsersoft.config.api.EngineLoggerRestartResponse;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.EngineStartProgress;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.MessageHandler;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.kubenode.ExecService;
import com.browsersoft.config.kubenode.KubeApiProvider;
import com.browsersoft.config.kubenode.configuration.KubeNodeConfiguration;
import com.browsersoft.config.utils.StreamUtils;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Response;

public class PodEngineRun
implements EngineRun {
    private ExecService execService;
    private String podId;
    private ConsoleWriter writer;
    private KubeApiProvider provider;
    private KubeNodeConfiguration configuration;

    public PodEngineRun(ExecService execService, String podId, KubeApiProvider provider, ConsoleWriter writer, KubeNodeConfiguration configuration) throws Exception {
        this.execService = execService;
        this.podId = podId;
        this.writer = writer;
        this.provider = provider;
        this.configuration = configuration;
    }

    public void runEngine(List<Consumer<Process>> startListeners) throws Exception {
    }

    public void stopEngine(UserInfo userInfo) throws Exception {
        String[] cmd = new String[]{"/opt/hie-engine/root/hieengine.sh", "stop"};
        this.execService.exec(this.podId, cmd, false);
    }

    public void killEngine() throws Exception {
        String[] cmd = new String[]{"sh", "-c", "kill 1"};
        this.execService.exec(this.podId, cmd, false);
    }

    public void deleteEngine() {
    }

    public void executeEngineCommand(String command) throws Exception {
    }

    public String getPid() {
        return "";
    }

    public EngineProcessState getState() throws Exception {
        String status;
        try {
            String[] cmd = new String[]{"/opt/hie-engine/root/hieengine.sh", "status"};
            status = new String(this.execService.exec(this.podId, cmd, false));
        }
        catch (Exception e) {
            return EngineProcessState.STOPPED;
        }
        if (status.contains("STARTED")) {
            return EngineProcessState.STARTED;
        }
        if (status.contains("STARTING")) {
            return EngineProcessState.STARTING;
        }
        return EngineProcessState.STOPPED;
    }

    public List<Message> getConsole(String lastMessageId) throws Exception {
        String[] lines;
        String s = "";
        try {
            CoreV1Api api = new CoreV1Api(this.provider.getApi());
            V1Pod pod = api.readNamespacedPod(this.podId, this.configuration.getKubernetesConfiguration().getNamespace(), null);
            String namespace = pod.getMetadata().getNamespace();
            String name = pod.getMetadata().getName();
            String container = ((V1Container)pod.getSpec().getContainers().get(0)).getName();
            Call call = api.readNamespacedPodLogCall(name, namespace, container, Boolean.valueOf(false), null, null, "false", Boolean.valueOf(false), null, Integer.valueOf(3000), null, null);
            Response response = call.execute();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (InputStream in = response.body().byteStream();){
                Streams.copy((InputStream)in, (OutputStream)byteArrayOutputStream);
            }
            response.close();
            s = byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception e) {
            s = StreamUtils.getExceptionStack((Throwable)e);
            this.writer.message(s, "error");
        }
        ArrayList<Message> ret = new ArrayList<Message>();
        for (String line : lines = s.split("\n", -1)) {
            ret.add(new Message(UUID.randomUUID().toString(), line, "info"));
        }
        return ret;
    }

    public void registerHandler(MessageHandler messageHandler) {
    }

    public void finish() {
    }

    public void backupData(String backupDestDirectory) throws Exception {
    }

    public File getRoot() {
        return null;
    }

    public byte[] readFile(String name) throws Exception {
        String[] cmd = new String[]{"cat", "/opt/hie-engine/root/" + name};
        return this.execService.exec(this.podId, cmd, false);
    }

    public String getEngineId() {
        return null;
    }

    public EngineLoggerRestartResponse restartLogger(UserInfo userInfo) throws Exception {
        String[] cmd = new String[]{"/opt/hie-engine/root/hieengine.sh", "loggerReset"};
        this.execService.exec(this.podId, cmd, false);
        return EngineLoggerRestartResponse.OK;
    }

    public EngineStartProgress getProgress() throws Exception {
        try {
            String[] cmd = new String[]{"/opt/hie-engine/root/hieengine.sh", "getProgress"};
            byte[] ret = this.execService.exec(this.podId, cmd, false);
            String str = new String(ret, StandardCharsets.UTF_8);
            return new EngineStartProgress(str);
        }
        catch (Exception e) {
            return new EngineStartProgress(0, "Stopped", "");
        }
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        throw new Exception("Not supported");
    }

    public byte[] getJstack() throws Exception {
        throw new Exception("Not supported");
    }

    public String checkRuntimeVersion() throws Exception {
        return "";
    }

    public void confirmJavaVersion(String version) throws Exception {
    }
}

