/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode;

import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.utils.StreamUtils;
import io.kubernetes.client.PortForward;
import io.kubernetes.client.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class PortForwardService {
    private String nameSpace;
    private String pod;
    private int localPort;
    private int targetPort;
    private ConsoleWriter consoleWriter;
    private ServerSocket ss;
    private boolean established;
    private Thread masterThread;
    private Thread outThread;
    private Thread inThread;

    public PortForwardService(String nameSpace, String pod, int localPort, int targetPort, ConsoleWriter consoleWriter) {
        this.nameSpace = nameSpace;
        this.pod = pod;
        this.localPort = localPort;
        this.targetPort = targetPort;
        this.consoleWriter = consoleWriter;
    }

    public void ensure() throws Exception {
        if (this.established) {
            return;
        }
        this.tryToEstablishForwarding();
    }

    public void reestablish() throws Exception {
    }

    private void closeAll() {
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void tryToEstablishForwarding() throws Exception {
        this.established = true;
        if (this.established) {
            return;
        }
        this.masterThread = new Thread(() -> {
            try {
                PortForward forward = new PortForward();
                ArrayList<Integer> ports = new ArrayList<Integer>();
                ports.add(this.targetPort);
                PortForward.PortForwardResult result = forward.forward(this.nameSpace, this.pod, ports);
                this.consoleWriter.message("Forwarding " + this.pod + " from " + this.localPort + " to " + this.targetPort, "info");
                this.ss = new ServerSocket(this.localPort);
                Socket s = this.ss.accept();
                this.consoleWriter.message("Connected!", "info");
                this.outThread = new Thread(() -> {
                    try {
                        Streams.copy((InputStream)result.getInputStream(this.targetPort), (OutputStream)s.getOutputStream());
                    }
                    catch (Exception ex) {
                        this.consoleWriter.message(StreamUtils.getExceptionStack((Throwable)ex), "error");
                    }
                });
                this.outThread.start();
                this.inThread = new Thread(() -> {
                    try {
                        Streams.copy((InputStream)s.getInputStream(), (OutputStream)result.getOutboundStream(this.targetPort));
                    }
                    catch (IOException ex) {
                        this.consoleWriter.message(StreamUtils.getExceptionStack((Throwable)ex), "error");
                    }
                });
                this.inThread.start();
                this.established = true;
            }
            catch (Exception e) {
                this.consoleWriter.message(StreamUtils.getExceptionStack((Throwable)e), "error");
            }
        });
        this.masterThread.start();
        for (int wait = 0; !this.established && wait < 4000; wait += 500) {
            Thread.sleep(500L);
        }
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public void setTargetPort(int targetPort) {
        this.targetPort = targetPort;
    }
}

