/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode;

import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.kubenode.PortForwardService;
import java.util.HashMap;
import java.util.Map;

public class PortForwardServices {
    private Map<String, PortForwardService> serviceMap = new HashMap<String, PortForwardService>();
    private ConsoleWriter consoleWriter;
    private String namespace;
    public static final int POD_CONTROL_INTERFACE_PORT = 9876;
    private int currentPort = 9876;

    public PortForwardServices(ConsoleWriter consoleWriter, String namespace) {
        this.consoleWriter = consoleWriter;
        this.namespace = namespace;
    }

    public synchronized PortForwardService getService(String pod) throws Exception {
        if (this.serviceMap.containsKey(pod)) {
            PortForwardService portForwardService = this.serviceMap.get(pod);
            portForwardService.ensure();
            return portForwardService;
        }
        PortForwardService portForwardService = new PortForwardService(this.namespace, pod, this.currentPort++, 9876, this.consoleWriter);
        this.serviceMap.put(pod, portForwardService);
        portForwardService.ensure();
        return portForwardService;
    }
}

