/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.configuration;

import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.w3c.dom.Node;

public class DockerRegistryConfiguration {
    private String url;
    private String user;
    private String password;
    private String jsonTemplate;
    private String secretTemplate;
    private String hardCodedRelease;

    public DockerRegistryConfiguration(Node node) throws Exception {
        this(DOMUtils.getParameter((Node)node, (String)"url"), DOMUtils.getParameter((Node)node, (String)"user"), DOMUtils.getParameter((Node)node, (String)"password"), DOMUtils.getParameter((Node)node, (String)"hardCodedRelease"));
    }

    public DockerRegistryConfiguration(String url, String user, String password, String hardCodedRelease) throws Exception {
        this.url = url;
        this.user = user;
        this.password = password;
        this.hardCodedRelease = hardCodedRelease;
        this.jsonTemplate = DockerRegistryConfiguration.loadTemplate("docker_config_json.tpl");
        this.secretTemplate = DockerRegistryConfiguration.loadTemplate("docker_registry_secret.tpl");
    }

    public String getSecretYaml(String url) throws Exception {
        URI uri = new URI("http://" + url);
        String host = uri.getHost();
        String authData = this.user + ":" + this.password;
        String auth = Base64.getEncoder().encodeToString(authData.getBytes(StandardCharsets.UTF_8));
        String json = this.jsonTemplate.replaceAll("%%HOST%%", host);
        json = json.replaceAll("%%AUTH%%", auth);
        String encodedJson = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
        String ret = this.secretTemplate.replaceAll("%%ENCODED_JSON%%", encodedJson);
        return ret;
    }

    public static String loadTemplate(String file) throws IOException {
        String filepath = "/com/browsersoft/config/kubenode/assets/" + file;
        try (InputStream in = DockerRegistryConfiguration.class.getResourceAsStream(filepath);){
            if (in == null) {
                throw new IOException("Template " + filepath + " not found!");
            }
            byte[] bytes = StreamUtils.loadInputStreamToBytes((InputStream)in);
            String string = new String(bytes, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static void main(String[] args) throws Exception {
        DockerRegistryConfiguration configuration = new DockerRegistryConfiguration("eu-frankfurt-1.ocir.io", "frzcfiay9tsa/jindrich.stejskal@gmail.com", "2yj+47j_wlc1fW5N<>-p", "");
        String yaml = configuration.getSecretYaml("eu-frankfurt-1.ocir.io");
        System.out.println(yaml);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHardCodedRelease() {
        return this.hardCodedRelease;
    }

    public void setHardCodedRelease(String hardCodedRelease) {
        this.hardCodedRelease = hardCodedRelease;
    }
}

