/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.configuration;

import com.browsersoft.config.api.StaticTransferableFileStorage;
import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.jgate.GateServerConfiguration;
import com.browsersoft.config.kubenode.configuration.DockerRegistryConfiguration;
import com.browsersoft.config.kubenode.configuration.KubernetesConfiguration;
import com.browsersoft.config.s3cli.AesAwsS3Configuration;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.FileUtils;
import java.io.File;
import java.nio.file.Path;
import org.w3c.dom.Node;

public class KubeNodeConfiguration {
    private final GateServerConfiguration gateServerConfiguration;
    private final String username;
    private final String password;
    private final File storageRoot;
    private KubernetesConfiguration kubernetesConfiguration;
    private TransferableFileStorage dirStorage;
    private TransferableFileStorage jarStorage;
    private AesAwsS3Configuration s3Configuration;
    private File consoleRoot;
    private DockerRegistryConfiguration dockerRegistryConfiguration;
    private boolean develMode;
    private String clientId;
    private File nodeRoot;

    public KubeNodeConfiguration(String configPath) throws Exception {
        this(DOMUtils.parseFile((String)configPath).getDocumentElement());
    }

    public KubeNodeConfiguration(Node node) throws Exception {
        String nodeRootStr;
        this.develMode = DOMUtils.getBooleanParameter((Node)node, (String)"develMode");
        this.clientId = DOMUtils.getParameter((Node)node, (String)"clientId", (String)"");
        File nodeRoot = null;
        Node upgradeNode = DOMUtils.getOneNodeChild((Node)node, (String)"upgrade");
        if (upgradeNode != null && (nodeRootStr = DOMUtils.getParameter((Node)upgradeNode, (String)"nodeRoot")) != null && !nodeRootStr.isEmpty()) {
            nodeRoot = new File(nodeRootStr);
        }
        if (nodeRoot == null) {
            nodeRoot = Path.of("", new String[0]).toAbsolutePath().toFile();
        }
        this.nodeRoot = nodeRoot;
        Node serverNode = DOMUtils.getOneNodeChild((Node)node, (String)"server");
        if (serverNode == null) {
            throw new Exception("Required configuration element 'server' not found!");
        }
        this.gateServerConfiguration = new GateServerConfiguration(serverNode);
        Node kubernetesNode = DOMUtils.getOneNodeChild((Node)node, (String)"kubernetes");
        if (kubernetesNode == null) {
            throw new Exception("Required configuration element 'kubernetes' not found!");
        }
        this.kubernetesConfiguration = new KubernetesConfiguration(kubernetesNode);
        Node accessNode = DOMUtils.getOneNodeChild((Node)node, (String)"access");
        if (accessNode == null) {
            throw new Exception("Required configuration element 'access' not found!");
        }
        this.username = DOMUtils.getParameter((Node)accessNode, (String)"user");
        this.password = DOMUtils.getParameter((Node)accessNode, (String)"password");
        Node storageNode = DOMUtils.getOneNodeChild((Node)node, (String)"storage");
        if (storageNode == null) {
            throw new Exception("Required configuration element 'storage' not found!");
        }
        this.storageRoot = FileUtils.ensureDirectory((String)DOMUtils.getParameter((Node)storageNode, (String)"root"));
        this.dirStorage = new StaticTransferableFileStorage(new File(this.storageRoot, "dirs"));
        this.jarStorage = new StaticTransferableFileStorage(new File(this.storageRoot, "jars"));
        Node s3storageNode = DOMUtils.getOneNodeChild((Node)node, (String)"s3storage");
        if (s3storageNode == null) {
            throw new Exception("Required configuration element 's3storage' not found!");
        }
        this.s3Configuration = new AesAwsS3Configuration(DOMUtils.getParameter((Node)s3storageNode, (String)"url"), DOMUtils.getParameter((Node)s3storageNode, (String)"accessKey"), DOMUtils.getParameter((Node)s3storageNode, (String)"secretKey"), DOMUtils.getParameter((Node)s3storageNode, (String)"region"), null, DOMUtils.getParameter((Node)s3storageNode, (String)"aesSecret"));
        Node consoleNode = DOMUtils.getOneNodeChild((Node)node, (String)"console");
        if (consoleNode == null) {
            throw new Exception("Required configuration element 'console' not found!");
        }
        this.consoleRoot = new File(DOMUtils.getParameter((Node)consoleNode, (String)"root"));
        Node dockerRegistryNode = DOMUtils.getOneNodeChild((Node)node, (String)"dockerRegistry");
        if (dockerRegistryNode == null) {
            throw new Exception("Required configuration element 'dockerRegistry' not found!");
        }
        this.dockerRegistryConfiguration = new DockerRegistryConfiguration(dockerRegistryNode);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GateServerConfiguration getGateServerConfiguration() {
        return this.gateServerConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public File getStorageRoot() {
        return this.storageRoot;
    }

    public KubernetesConfiguration getKubernetesConfiguration() {
        return this.kubernetesConfiguration;
    }

    public void setKubernetesConfiguration(KubernetesConfiguration kubernetesConfiguration) {
        this.kubernetesConfiguration = kubernetesConfiguration;
    }

    public TransferableFileStorage getDirStorage() {
        return this.dirStorage;
    }

    public void setDirStorage(TransferableFileStorage dirStorage) {
        this.dirStorage = dirStorage;
    }

    public AesAwsS3Configuration getS3Configuration() {
        return this.s3Configuration;
    }

    public void setS3Configuration(AesAwsS3Configuration s3Configuration) {
        this.s3Configuration = s3Configuration;
    }

    public File getConsoleRoot() {
        return this.consoleRoot;
    }

    public void setConsoleRoot(File consoleRoot) {
        this.consoleRoot = consoleRoot;
    }

    public DockerRegistryConfiguration getDockerRegistryConfiguration() {
        return this.dockerRegistryConfiguration;
    }

    public void setDockerRegistryConfiguration(DockerRegistryConfiguration dockerRegistryConfiguration) {
        this.dockerRegistryConfiguration = dockerRegistryConfiguration;
    }

    public TransferableFileStorage getJarStorage() {
        return this.jarStorage;
    }

    public void setJarStorage(TransferableFileStorage jarStorage) {
        this.jarStorage = jarStorage;
    }

    public boolean isDevelMode() {
        return this.develMode;
    }

    public void setDevelMode(boolean develMode) {
        this.develMode = develMode;
    }

    public File getUpdatePath() {
        return new File(this.nodeRoot, "deploy");
    }

    public File getNodeRoot() {
        return this.nodeRoot;
    }
}

