/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.configuration;

import com.browsersoft.config.utils.DOMUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.KubeConfig;
import java.io.FileReader;
import java.io.Reader;
import org.w3c.dom.Node;

public class KubernetesConfiguration {
    private String url;
    private String token;
    private String namespace;
    private String kubeConfigPath;
    private boolean debug;
    private String type;
    private String storageClassName;

    public KubernetesConfiguration(Node node) {
        this.token = DOMUtils.getParameter((Node)node, (String)"token");
        this.url = DOMUtils.getParameter((Node)node, (String)"url");
        this.namespace = DOMUtils.getParameter((Node)node, (String)"namespace");
        this.kubeConfigPath = DOMUtils.getParameter((Node)node, (String)"kubeConfigPath");
        this.type = DOMUtils.getParameter((Node)node, (String)"type");
        this.storageClassName = this.type.equals("oci") ? "oci-bv" : (this.type.equals("azure") ? "managed-csi" : "nfs");
        this.debug = DOMUtils.getBooleanParameter((Node)node, (String)"debug");
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getKubeConfigPath() {
        return this.kubeConfigPath;
    }

    public void setKubeConfigPath(String kubeConfigPath) {
        this.kubeConfigPath = kubeConfigPath;
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApiClient getApi() throws Exception {
        ApiClient client = this.kubeConfigPath != null && !this.kubeConfigPath.equals("") ? ClientBuilder.kubeconfig((KubeConfig)KubeConfig.loadKubeConfig((Reader)new FileReader(this.kubeConfigPath))).build() : Config.fromToken((String)this.url, (String)this.token, (boolean)false);
        client.setDebugging(this.debug);
        Configuration.setDefaultApiClient((ApiClient)client);
        return client;
    }
}

