/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.deploy;

import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.kubenode.configuration.KubeNodeConfiguration;
import com.browsersoft.config.kubenode.configuration.KubernetesConfiguration;
import com.browsersoft.config.kubenode.deploy.DeployStrategy;
import com.browsersoft.config.kubenode.handlers.AbstractHandler;
import com.browsersoft.config.kubenode.handlers.DeploymentHandler;
import com.browsersoft.config.kubenode.handlers.IngressHandler;
import com.browsersoft.config.kubenode.handlers.SecretHandler;
import com.browsersoft.config.kubenode.handlers.ServiceHandler;
import com.browsersoft.config.kubenode.handlers.StatefulSetHandler;
import com.browsersoft.config.utils.StreamUtils;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.util.PatchUtils;
import io.kubernetes.client.util.Yaml;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;

public abstract class DefaultDeployStrategy
implements DeployStrategy {
    @Override
    public void deploy(ApiClient client, String yaml, KubeNodeConfiguration configuration, ConsoleWriter consoleWriter) throws Exception {
        CoreV1Api api = new CoreV1Api(client);
        AppsV1Api appsV1Api = new AppsV1Api(client);
        NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
        consoleWriter.message("--------------------", "info");
        consoleWriter.message("Deploying solution", "info");
        consoleWriter.message("--------------------", "info");
        Map<Class<?>, Set<String>> itemsToSkipFromDelete = this.getItemsToSkipInDelete(yaml);
        this.clearAll(client, itemsToSkipFromDelete, configuration.getKubernetesConfiguration(), consoleWriter);
        for (String s : yaml.split("---")) {
            V1StatefulSet statefulSet;
            V1Ingress result;
            V1Patch patch;
            consoleWriter.message("Deploying yaml part", "info");
            consoleWriter.message("--------------------", "info");
            s = s.trim();
            consoleWriter.message(s, "info");
            consoleWriter.message("--------------------", "info");
            Object o = Yaml.load((String)s);
            if (o instanceof V1Service) {
                V1Service service = (V1Service)o;
                patch = new V1Patch(s);
                consoleWriter.message("applying patch", "info");
                V1Service service1 = (V1Service)PatchUtils.patch(V1Service.class, () -> api.patchNamespacedServiceCall(service.getMetadata().getName(), configuration.getKubernetesConfiguration().getNamespace(), patch, null, null, "example-field-manager", null, Boolean.valueOf(true), null), (String)"application/apply-patch+yaml", (ApiClient)api.getApiClient());
                consoleWriter.message("OK", "info");
                continue;
            }
            if (o instanceof V1Ingress) {
                V1Ingress ingress = (V1Ingress)o;
                patch = new V1Patch(s);
                consoleWriter.message("applying patch", "info");
                result = (V1Ingress)PatchUtils.patch(V1Ingress.class, () -> networkingV1Api.patchNamespacedIngressCall(ingress.getMetadata().getName(), configuration.getKubernetesConfiguration().getNamespace(), patch, null, null, "example-field-manager", null, Boolean.valueOf(true), null), (String)"application/apply-patch+yaml", (ApiClient)api.getApiClient());
                consoleWriter.message("OK", "info");
                continue;
            }
            if (o instanceof V1Secret) {
                V1Secret secret = (V1Secret)o;
                patch = new V1Patch(s);
                consoleWriter.message("applying patch", "info");
                result = (V1Secret)PatchUtils.patch(V1Secret.class, () -> api.patchNamespacedSecretCall(secret.getMetadata().getName(), configuration.getKubernetesConfiguration().getNamespace(), patch, null, null, "example-field-manager", null, Boolean.valueOf(true), null), (String)"application/apply-patch+yaml", (ApiClient)api.getApiClient());
                consoleWriter.message("OK", "info");
                continue;
            }
            if (o instanceof V1StatefulSet) {
                statefulSet = (V1StatefulSet)o;
                patch = new V1Patch(s);
                consoleWriter.message("applying patch", "info");
                result = (V1StatefulSet)PatchUtils.patch(V1StatefulSet.class, () -> appsV1Api.patchNamespacedStatefulSetCall(statefulSet.getMetadata().getName(), configuration.getKubernetesConfiguration().getNamespace(), patch, null, null, "example-field-manager", null, Boolean.valueOf(true), null), (String)"application/apply-patch+yaml", (ApiClient)api.getApiClient());
                consoleWriter.message("OK", "info");
                continue;
            }
            if (!(o instanceof V1Deployment)) continue;
            statefulSet = (V1Deployment)o;
            patch = new V1Patch(s);
            consoleWriter.message("applying patch", "info");
            result = (V1Deployment)PatchUtils.patch(V1Deployment.class, () -> DefaultDeployStrategy.lambda$deploy$4(appsV1Api, (V1Deployment)statefulSet, configuration, patch), (String)"application/apply-patch+yaml", (ApiClient)api.getApiClient());
            consoleWriter.message("OK", "info");
        }
    }

    protected abstract Map<Class<?>, Set<String>> getItemsToSkipInDelete(String var1) throws Exception;

    protected boolean shouldSkipDelete(Object o) {
        V1Secret secret;
        if (o instanceof V1ServiceAccount) {
            return true;
        }
        return o instanceof V1Secret && (secret = (V1Secret)o).getMetadata() != null && secret.getMetadata().getAnnotations() != null && secret.getMetadata().getAnnotations().containsKey("kubernetes.io/service-account.name");
    }

    private void clearAll(ApiClient client, Map<Class<?>, Set<String>> itemsToSkip, KubernetesConfiguration configuration, ConsoleWriter consoleWriter) throws ApiException {
        try {
            consoleWriter.message("--------------------", "info");
            consoleWriter.message("Cleaning All", "info");
            consoleWriter.message("--------------------", "info");
            this.clearObjects(new IngressHandler(client, configuration.getNamespace()), itemsToSkip, consoleWriter);
            this.clearObjects(new SecretHandler(client, configuration.getNamespace()), itemsToSkip, consoleWriter);
            this.clearObjects(new ServiceHandler(client, configuration.getNamespace()), itemsToSkip, consoleWriter);
            this.clearObjects(new DeploymentHandler(client, configuration.getNamespace()), itemsToSkip, consoleWriter);
            this.clearObjects(new StatefulSetHandler(client, configuration.getNamespace()), itemsToSkip, consoleWriter);
        }
        catch (Exception e) {
            consoleWriter.message(StreamUtils.getExceptionStack((Throwable)e), "error");
        }
    }

    private void clearObjects(AbstractHandler<?, ?> handler, Map<Class<?>, Set<String>> itemsToSkip, ConsoleWriter consoleWriter) throws ApiException {
        Set namesToSkip = itemsToSkip.getOrDefault(handler.getObjectClass(), null);
        Object list = handler.list();
        for (KubernetesObject item : list.getItems()) {
            if (this.shouldSkipDelete(item)) continue;
            String itemName = item.getMetadata().getName();
            if (namesToSkip != null && namesToSkip.contains(itemName)) continue;
            consoleWriter.message(String.format("Deleting %s %s ...", handler.getObjectName(), itemName), "info");
            handler.delete(itemName);
            consoleWriter.message("OK", "info");
        }
    }

    private static /* synthetic */ Call lambda$deploy$4(AppsV1Api appsV1Api, V1Deployment statefulSet, KubeNodeConfiguration configuration, V1Patch patch) throws ApiException {
        return appsV1Api.patchNamespacedDeploymentCall(statefulSet.getMetadata().getName(), configuration.getKubernetesConfiguration().getNamespace(), patch, null, null, "example-field-manager", null, Boolean.valueOf(true), null);
    }
}

