/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.deploy;

import com.browsersoft.config.console.ConsoleWriter;
import com.browsersoft.config.kubenode.configuration.KubeNodeConfiguration;
import com.browsersoft.config.kubenode.configuration.KubernetesConfiguration;
import com.browsersoft.config.kubenode.deploy.DeployStrategy;
import com.browsersoft.config.utils.StreamUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetList;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.util.Yaml;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RedeployAllStrategyOld
implements DeployStrategy {
    @Override
    public void deploy(ApiClient client, String yaml, KubeNodeConfiguration configuration, ConsoleWriter consoleWriter) throws Exception {
        CoreV1Api api = new CoreV1Api(client);
        AppsV1Api appsV1Api = new AppsV1Api(client);
        NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
        RedeployAllStrategyOld.clearAll(client, new HashMap(), configuration.getKubernetesConfiguration(), consoleWriter);
        for (String s : yaml.split("---")) {
            V1Ingress result;
            consoleWriter.message("Deploying yaml part", "info");
            consoleWriter.message("--------------------", "info");
            s = s.trim();
            consoleWriter.message(s, "info");
            consoleWriter.message("--------------------", "info");
            Object o = Yaml.load((String)s);
            if (o instanceof V1Service) {
                V1Service service = (V1Service)o;
                consoleWriter.message("Deploying service " + service.getMetadata().getName() + " ...", "info");
                V1Service createResult = api.createNamespacedService(configuration.getKubernetesConfiguration().getNamespace(), service, null, null, null, null);
                consoleWriter.message("OK", "info");
                continue;
            }
            if (o instanceof V1Deployment) {
                V1Deployment deployment = (V1Deployment)o;
                consoleWriter.message("Deploying deployment " + deployment.getMetadata().getName() + " ...", "info");
                V1Deployment createDeployment = appsV1Api.createNamespacedDeployment(configuration.getKubernetesConfiguration().getNamespace(), deployment, null, null, null, null);
                consoleWriter.message("OK", "info");
                continue;
            }
            if (o instanceof V1Ingress) {
                V1Ingress ingress = (V1Ingress)o;
                consoleWriter.message("Deploying ingress " + ingress.getMetadata().getName() + " ...", "info");
                result = networkingV1Api.createNamespacedIngress(configuration.getKubernetesConfiguration().getNamespace(), ingress, null, null, null, null);
                consoleWriter.message("OK", "info");
                continue;
            }
            if (o instanceof V1Secret) {
                V1Secret secret = (V1Secret)o;
                consoleWriter.message("Deploying secret " + secret.getMetadata().getName() + " ...", "info");
                result = api.createNamespacedSecret(configuration.getKubernetesConfiguration().getNamespace(), secret, null, null, null, null);
                consoleWriter.message("OK", "info");
                continue;
            }
            if (!(o instanceof V1StatefulSet)) continue;
            V1StatefulSet statefulSet = (V1StatefulSet)o;
            consoleWriter.message("Deploying statefullSet " + statefulSet.getMetadata().getName() + " ...", "info");
            V1StatefulSet createStatefulSet = appsV1Api.createNamespacedStatefulSet(configuration.getKubernetesConfiguration().getNamespace(), statefulSet, null, null, null, null);
            consoleWriter.message("OK", "info");
        }
    }

    public static void clearAll(ApiClient client, Map<Class<?>, Set<String>> itemsToSkip, KubernetesConfiguration configuration, ConsoleWriter consoleWriter) throws ApiException {
        try {
            CoreV1Api api = new CoreV1Api(client);
            AppsV1Api appsV1Api = new AppsV1Api(client);
            NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
            consoleWriter.message("--------------------", "info");
            consoleWriter.message("Cleaning All", "info");
            consoleWriter.message("--------------------", "info");
            V1IngressList v1IngressList = networkingV1Api.listNamespacedIngress(configuration.getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (Object ingress : v1IngressList.getItems()) {
                Set names = itemsToSkip.getOrDefault(V1Ingress.class, null);
                if (names != null && names.contains(ingress.getMetadata().getName())) continue;
                consoleWriter.message("Deleting ingress " + ingress.getMetadata().getName() + " ...", "info");
                V1Status status = networkingV1Api.deleteNamespacedIngress(ingress.getMetadata().getName(), configuration.getNamespace(), null, null, null, null, null, null);
                consoleWriter.message("OK", "info");
            }
            V1SecretList secretList = api.listNamespacedSecret(configuration.getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (Object secret : secretList.getItems()) {
                Set names = itemsToSkip.getOrDefault(V1Secret.class, null);
                if (names != null && names.contains(secret.getMetadata().getName())) continue;
                consoleWriter.message("Deleting secret " + secret.getMetadata().getName() + " ...", "info");
                V1Status status = api.deleteNamespacedSecret(secret.getMetadata().getName(), configuration.getNamespace(), null, null, null, null, null, null);
                consoleWriter.message("OK", "info");
            }
            V1ServiceList serviceList = api.listNamespacedService(configuration.getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (Object service : serviceList.getItems()) {
                Set names = itemsToSkip.getOrDefault(V1Service.class, null);
                if (names != null && names.contains(service.getMetadata().getName())) continue;
                consoleWriter.message("Deleting service " + service.getMetadata().getName() + " ...", "info");
                api.deleteNamespacedService(service.getMetadata().getName(), configuration.getNamespace(), null, null, null, null, null, null);
                consoleWriter.message("OK", "info");
            }
            V1DeploymentList deploymentList = appsV1Api.listNamespacedDeployment(configuration.getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (V1Deployment deployment : deploymentList.getItems()) {
                Set names = itemsToSkip.getOrDefault(V1Deployment.class, null);
                if (names != null && names.contains(deployment.getMetadata().getName())) continue;
                consoleWriter.message("Deleting deployment " + deployment.getMetadata().getName() + " ...", "info");
                V1Status status = appsV1Api.deleteNamespacedDeployment(deployment.getMetadata().getName(), configuration.getNamespace(), null, null, null, null, null, null);
                consoleWriter.message("OK", "info");
            }
            V1StatefulSetList statefulSetList = appsV1Api.listNamespacedStatefulSet(configuration.getNamespace(), null, null, null, null, null, null, null, null, null, null);
            for (V1StatefulSet statefulSet : statefulSetList.getItems()) {
                Set names = itemsToSkip.getOrDefault(V1StatefulSet.class, null);
                if (names != null && names.contains(statefulSet.getMetadata().getName())) continue;
                consoleWriter.message("Deleting statefullset " + statefulSet.getMetadata().getName() + " ...", "info");
                V1Status status = appsV1Api.deleteNamespacedStatefulSet(statefulSet.getMetadata().getName(), configuration.getNamespace(), null, null, null, null, null, null);
                consoleWriter.message("OK", "info");
            }
        }
        catch (Exception e) {
            consoleWriter.message(StreamUtils.getExceptionStack((Throwable)e), "error");
        }
    }
}

