/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.terminals;

import com.browsersoft.config.kubenode.terminals.TerminalBufferOutputStream;
import io.kubernetes.client.Exec;
import io.kubernetes.client.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class PodTerminal {
    private Process process;
    private TerminalBufferOutputStream outputStream = new TerminalBufferOutputStream();
    private OutputStream processOutputStream;
    private Thread out;
    private Thread outErr;
    private Date lastAccess = new Date();

    public PodTerminal(String namespace, String podName) throws Exception {
        Exec exec = new Exec();
        this.process = exec.exec(namespace, podName, new String[]{"sh"}, true, true);
        this.out = new Thread(() -> {
            try {
                Streams.copy((InputStream)this.process.getInputStream(), (OutputStream)this.outputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.out.start();
        this.outErr = new Thread(() -> {
            try {
                Streams.copy((InputStream)this.process.getErrorStream(), (OutputStream)this.outputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.outErr.start();
        this.processOutputStream = this.process.getOutputStream();
    }

    public byte[] read() throws Exception {
        return this.outputStream.read();
    }

    public void write(byte[] bytes) throws Exception {
        this.processOutputStream.write(bytes);
        this.lastAccess = new Date();
    }

    public void close() {
        this.process.destroy();
        this.out.interrupt();
        this.outErr.interrupt();
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }
}

