/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.terminals;

import com.browsersoft.config.kubenode.terminals.PodTerminal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public class PodTerminals {
    private Map<String, PodTerminal> outs = new HashMap<String, PodTerminal>();

    public PodTerminals() {
        Thread t = new Thread(() -> {
            try {
                while (true) {
                    this.removeOld();
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        t.start();
    }

    public synchronized String newTerminal(String namespace, String pod) throws Exception {
        String id = UUID.randomUUID().toString();
        this.outs.put(id, new PodTerminal(namespace, pod));
        return id;
    }

    public synchronized void removeOld() throws Exception {
        long now = new Date().getTime();
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, PodTerminal> entry : this.outs.entrySet()) {
            if (entry.getValue().getLastAccess().getTime() >= now - 300000L) continue;
            toRemove.add(entry.getKey());
        }
        for (String s : toRemove) {
            this.outs.get(s).close();
            this.outs.remove(s);
        }
    }

    public synchronized byte[] read(String uuid) throws Exception {
        return this.outs.get(uuid).read();
    }

    public synchronized void write(String uuid, byte[] bytes) throws Exception {
        this.outs.get(uuid).write(bytes);
    }

    public synchronized void close(String uuid) throws Exception {
        if (this.outs.get(uuid) != null) {
            this.outs.get(uuid).close();
        }
        this.outs.remove(uuid);
    }
}

