/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.tests;

import com.browsersoft.config.api.FileInfo;
import com.browsersoft.config.kubenode.KubeNodeService;
import io.kubernetes.client.Exec;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;

public class TestExec {
    private static ApiClient getApi() throws Exception {
        String kubeConfigPath = "/Users/jindra/.kube/config";
        ApiClient client = ClientBuilder.kubeconfig((KubeConfig)KubeConfig.loadKubeConfig((Reader)new FileReader(kubeConfigPath))).build();
        return client;
    }

    public static void main(String[] args) throws Exception {
        ApiClient client = TestExec.getApi();
        Configuration.setDefaultApiClient((ApiClient)client);
        Exec exec = new Exec();
        boolean tty = System.console() != null;
        String[] cmd = new String[]{"./opt/hie-engine/root/hieengine.sh", "list", "/"};
        Process proc = exec.exec("hie", "main-0", cmd, true, tty);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Thread in = new Thread(() -> {
            try {
                Streams.copy((InputStream)System.in, (OutputStream)proc.getOutputStream());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        in.start();
        Thread out = new Thread(() -> {
            try {
                Streams.copy((InputStream)proc.getInputStream(), (OutputStream)outputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        out.start();
        proc.waitFor();
        out.join();
        proc.destroy();
        String s = new String(outputStream.toByteArray());
        System.out.println(s);
        List<FileInfo> ret = KubeNodeService.parseFiles(s);
        System.out.println(ret);
        System.exit(proc.exitValue());
    }
}

