/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.tests;

import com.browsersoft.config.utils.FileUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Yaml;
import java.io.File;

public class TestKubernetes {
    public static void main(String[] args) throws Exception {
        ApiClient client = TestKubernetes.getApi();
        CoreV1Api api = new CoreV1Api(client);
        AppsV1Api appsV1Api = new AppsV1Api(client);
        NetworkingV1Api networkingV1Api = new NetworkingV1Api(client);
        String yaml = FileUtils.loadFileToString((File)new File("/Users/jindra/projects/lb/hie-configurator/kubenode/src/com/browsersoft/config/kubenode/test.yaml"));
        for (String s : yaml.split("---")) {
            V1Ingress result;
            Object o = Yaml.load((String)(s = s.trim()));
            if (o instanceof V1Service) {
                V1Service service = (V1Service)o;
                V1Service createResult = api.createNamespacedService("hie01", service, null, null, null, null);
                System.out.println(createResult);
                continue;
            }
            if (o instanceof V1Deployment) {
                V1Deployment deployment = (V1Deployment)o;
                V1Deployment createDeployment = appsV1Api.createNamespacedDeployment("hie01", deployment, null, null, null, null);
                System.out.println(createDeployment);
                continue;
            }
            if (o instanceof V1Ingress) {
                V1Ingress ingress = (V1Ingress)o;
                result = networkingV1Api.createNamespacedIngress("hie01", ingress, null, null, null, null);
                System.out.println(result);
                continue;
            }
            if (!(o instanceof V1Secret)) continue;
            V1Secret secret = (V1Secret)o;
            result = api.createNamespacedSecret("hie01", secret, null, null, null, null);
            System.out.println(result);
        }
    }

    private static ApiClient getApi() {
        ApiClient client = Config.fromToken((String)"https://k8s01-m01.dev.ententee.com:6443/", (String)"31ada4fd-adec-460c-809a-9e56ceb75269", (boolean)false);
        client.setDebugging(true);
        Configuration.setDefaultApiClient((ApiClient)client);
        return client;
    }
}

