/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.kubenode.utils;

import com.browsersoft.config.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class AssetsUtils {
    public static byte[] getResource(String file) throws IOException {
        String resourcePath = "/com/browsersoft/config/kubenode/assets/" + file;
        try (InputStream in = AssetsUtils.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = StreamUtils.loadInputStreamToBytes((InputStream)in);
            return byArray;
        }
    }

    public static String renderTemplate(String file, Map<String, String> data) throws Exception {
        byte[] bytes = AssetsUtils.getResource(file);
        if (bytes == null) {
            return null;
        }
        String tpl = new String(bytes, StandardCharsets.UTF_8);
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                tpl = tpl.replace("%%" + entry.getKey() + "%%", entry.getValue());
            }
        }
        tpl = tpl.replaceAll("\r\n", "\n");
        return tpl;
    }
}

