/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineLoggerRestartResponse;
import com.browsersoft.config.api.EngineProcess;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.LocalEngineRun;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.UserInfo;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEngineProcess
implements EngineProcess {
    protected EngineRun engineRun;
    private static final Logger logger = LoggerFactory.getLogger(AsyncEngineProcess.class);

    public AsyncEngineProcess(EngineRun engineRun) {
        this.engineRun = engineRun;
    }

    @Override
    public String getConsole() throws Exception {
        List<Message> messages = this.engineRun.getConsole("");
        StringBuilder stringBuilder = new StringBuilder();
        for (Message message : messages) {
            stringBuilder.append(message.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getPid() throws Exception {
        if (this.engineRun == null) {
            return "";
        }
        return this.engineRun.getPid();
    }

    @Override
    public List<Message> getConsole(String lastMessageId) throws Exception {
        return this.engineRun.getConsole(lastMessageId);
    }

    @Override
    public EngineProcessState getState() throws Exception {
        return this.engineRun.getState();
    }

    @Override
    public void stopProcess(UserInfo userInfo) throws Exception {
        switch (this.getState()) {
            case STOPPED: {
                break;
            }
            case STARTING: 
            case STARTED: {
                try {
                    this.engineRun.stopEngine(userInfo);
                    break;
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
    }

    public void startProcess(UserInfo userInfo, int timeout) throws Exception {
        this.startProcess(userInfo);
        try {
            long engineStartTime = new Date().getTime();
            while (this.getState() != EngineProcessState.STARTED) {
                Thread.sleep(200L);
                if (new Date().getTime() - engineStartTime <= (long)timeout) continue;
                throw new Exception("Engine start timeout.");
            }
        }
        catch (Exception e) {
            this.stopProcess(userInfo);
            throw e;
        }
    }

    @Override
    public void startProcess(UserInfo userInfo, final List<Consumer<Process>> startListeners) throws Exception {
        switch (this.getState()) {
            case STOPPED: {
                if (this.engineRun instanceof LocalEngineRun) {
                    ((LocalEngineRun)this.engineRun).verifyRelease();
                }
                Thread runThread = new Thread("async-start::" + this.engineRun.getEngineId()){

                    @Override
                    public void run() {
                        try {
                            AsyncEngineProcess.this.engineRun.runEngine(startListeners);
                        }
                        catch (Exception e) {
                            logger.warn("Exception while running engine", (Throwable)e);
                        }
                    }
                };
                runThread.setDaemon(true);
                runThread.start();
                break;
            }
            case STARTING: {
                break;
            }
        }
    }

    @Override
    public byte[] getJstack() throws Exception {
        return this.engineRun.getJstack();
    }

    @Override
    public void restartProcess(UserInfo userInfo) {
        try {
            this.stopProcess(userInfo);
            while (this.getState() != EngineProcessState.STOPPED) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warn("", (Throwable)e);
                }
            }
            this.startProcess(userInfo);
        }
        catch (Exception e) {
            logger.warn("Exception while restarting process", (Throwable)e);
        }
    }

    @Override
    public void killProcess(UserInfo userInfo) {
        try {
            this.engineRun.killEngine();
        }
        catch (Exception e) {
            logger.warn("Exception while killing engine", (Throwable)e);
        }
    }

    @Override
    public void executeEngineCommand(final String command) {
        try {
            switch (this.getState()) {
                case STOPPED: {
                    if (this.engineRun instanceof LocalEngineRun) {
                        ((LocalEngineRun)this.engineRun).verifyRelease();
                    }
                    Thread runThread = new Thread("async-execute::" + this.engineRun.getEngineId()){

                        @Override
                        public void run() {
                            try {
                                AsyncEngineProcess.this.engineRun.executeEngineCommand(command);
                            }
                            catch (Exception e) {
                                logger.warn("Exception while running engine command", (Throwable)e);
                            }
                        }
                    };
                    runThread.setDaemon(true);
                    runThread.start();
                    break;
                }
                case STARTING: {
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception while executing engine command", (Throwable)e);
        }
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        return this.engineRun.handleStepRequest(boxId, o);
    }

    @Override
    public byte[] readFile(String name) throws Exception {
        return this.engineRun.readFile(name);
    }

    @Override
    public EngineLoggerRestartResponse restartLogger(UserInfo userInfo) throws Exception {
        return this.engineRun.restartLogger(userInfo);
    }

    public EngineRun getEngineRun() {
        return this.engineRun;
    }

    @Override
    public void confirmRuntimeVersion(String version) throws Exception {
    }

    @Override
    public String checkRuntimeVersion() throws Exception {
        return "";
    }
}

