/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.hub.ConfigItemRecord;
import com.browsersoft.config.api.hub.ConfigItemRecordType;
import com.browsersoft.config.api.hub.ConfigRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigItemRecordUtils {
    public static void getAllConfigItemRecordsOfGivenTypeAndPathAndChildFolders(ConfigItemRecordType searchedType, List<ConfigItemRecord> searchedPath, ConfigItemRecord currentConfigItem, ConfigRepository repository, Map<String, ConfigItemRecord> mapWithPathAndConfigItemRecordToIt) throws Exception {
        if (searchedPath.size() == 0) {
            return;
        }
        if (currentConfigItem.getType() == searchedType) {
            mapWithPathAndConfigItemRecordToIt.put(ConfigItemRecordUtils.getPathAsString(searchedPath), currentConfigItem);
        }
        switch (currentConfigItem.getType()) {
            case CONFIGURATOR_FOLDER: 
            case CONFIGURATOR_USERS_FOLDER: 
            case RELEASEHUB_LICENSES_FOLDER: 
            case RELEASEHUB_FOLDER: 
            case RELEASEHUB_USERS_FOLDER: 
            case RELEASE_HUB_FOLDER_RIGHT: 
            case CONFIGURATOR_FOLDER_RIGHT: {
                List<ConfigItemRecord> itemRecords = repository.getItems(searchedPath, "");
                while (itemRecords.size() > 0) {
                    ConfigItemRecord iteratedRecord = itemRecords.remove(0);
                    ArrayList<ConfigItemRecord> extendedPath = new ArrayList<ConfigItemRecord>(searchedPath);
                    extendedPath.add(iteratedRecord);
                    ConfigItemRecordUtils.getAllConfigItemRecordsOfGivenTypeAndPathAndChildFolders(searchedType, extendedPath, iteratedRecord, repository, mapWithPathAndConfigItemRecordToIt);
                }
                break;
            }
        }
    }

    private static String getPathAsString(List<ConfigItemRecord> path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            ConfigItemRecord record = path.get(i);
            sb.append(record.getName());
            if (i == path.size() - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }
}

