/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.UserInfoProvider;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemFactory;
import com.browsersoft.config.settings.SettingsProvider;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EnginesGround {
    private static final String PERSISTENT_DIR_SUFFIX = "@persistent";
    private final SettingsProvider provider;
    private static final Logger log = LoggerFactory.getLogger(EnginesGround.class);
    private List<Consumer<Process>> startListeners = new ArrayList<Consumer<Process>>();

    public EnginesGround(SettingsProvider provider) {
        this.provider = provider;
    }

    public void addStartListener(Consumer<Process> startListener) {
        this.startListeners.add(startListener);
    }

    public synchronized EngineGround newEngine(String externalId, String name, String releaseName, String javaBinDir, String releaseJavaVersion) throws Exception {
        EngineGround originalEngine = null;
        try {
            originalEngine = this.getEngineByExternalId(externalId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<EngineGround> infos = this.getEngines();
        int newPort = this.provider.getSettings().getMinEngineControlPort();
        while (!this.checkPort(newPort, infos)) {
            if (++newPort <= this.provider.getSettings().getMaxEngineControlPort()) continue;
            throw new Exception("No free port available for control interface");
        }
        Object engineDirName = externalId;
        if (engineDirName == null) {
            engineDirName = "engine_" + newPort;
        }
        EngineGround engineInfo = new EngineGround(this);
        engineInfo.setEngineId(originalEngine != null ? originalEngine.getEngineId() : UUID.randomUUID().toString());
        engineInfo.setFile(new File(this.getRoot(), (String)engineDirName));
        engineInfo.setPersistenceRoot(new File(this.getRoot(), (String)engineDirName + PERSISTENT_DIR_SUFFIX));
        engineInfo.setPort(originalEngine != null ? originalEngine.getPort() : newPort);
        engineInfo.setName(name);
        engineInfo.setReleaseName(releaseName);
        engineInfo.setExternalId(externalId);
        engineInfo.setUserInfo(UserInfoProvider.getUserInfo());
        engineInfo.setDeployed(new Date());
        engineInfo.setReleaseJavaVersion(releaseJavaVersion);
        engineInfo.setPathToJavaBinDir(javaBinDir);
        if (engineInfo.getFile().exists()) {
            FileUtils.deleteDir((File)engineInfo.getFile());
        }
        engineInfo.getFile().mkdirs();
        engineInfo.getPersistenceRoot().mkdirs();
        File file = new File(engineInfo.getFile(), "engine.xml");
        FileUtils.saveBytesToFile((File)file, (byte[])engineInfo.saveToXml().getBytes("UTF-8"));
        return engineInfo;
    }

    public EngineGround newProjectEngine(File projectRoot, String name, String path, Integer engineNumber) throws Exception {
        int port = 8981;
        Object runFolderName = "run";
        Object persistentRootName = "persistence_root";
        String engineId = "PROJECT_ID";
        if (engineNumber != null && engineNumber >= 2) {
            port += engineNumber.intValue();
            runFolderName = (String)runFolderName + String.valueOf(engineNumber);
            persistentRootName = (String)persistentRootName + String.valueOf(engineNumber);
            engineId = String.format("%s_%d", engineId, engineNumber);
        }
        EngineGround engineInfo = new EngineGround(this);
        engineInfo.setEngineId(engineId);
        engineInfo.setFile(new File(projectRoot, (String)runFolderName));
        engineInfo.setName(name);
        engineInfo.setPersistenceRoot(new File(projectRoot, (String)persistentRootName));
        engineInfo.setPort(port);
        if (engineInfo.getFile().exists()) {
            FileUtils.deleteDir((File)engineInfo.getFile());
        }
        engineInfo.getFile().mkdir();
        File file = new File(engineInfo.getFile(), "engine.xml");
        FileUtils.saveBytesToFile((File)file, (byte[])engineInfo.saveToXml().getBytes("UTF-8"));
        File redeployTxt = new File(engineInfo.getFile(), "redeploy.txt");
        FileUtils.saveBytesToFile((File)redeployTxt, (byte[])path.getBytes("UTF-8"));
        return engineInfo;
    }

    private boolean checkPort(int port, List<EngineGround> infos) {
        for (EngineGround engineInfo : infos) {
            if (engineInfo.getPort() != port) continue;
            return false;
        }
        return true;
    }

    public List<EngineGround> getEngines() {
        File[] files = this.getRoot().listFiles();
        if (files == null) {
            return new ArrayList<EngineGround>();
        }
        ArrayList<EngineGround> ret = new ArrayList<EngineGround>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            try {
                EngineGround engineInfo = this.constructInfo(file);
                if (engineInfo == null) continue;
                for (Consumer<Process> startListener : this.startListeners) {
                    engineInfo.addStartConsumer(startListener);
                }
                ret.add(engineInfo);
            }
            catch (Exception e) {
                log.warn("Get engines exception", (Throwable)e);
            }
        }
        return ret;
    }

    public EngineGround getEngine(String engineId) throws Exception {
        List<EngineGround> engines = this.getEngines();
        for (EngineGround engineGround : engines) {
            if (!engineGround.getEngineId().equals(engineId)) continue;
            return engineGround;
        }
        throw new Exception("Unknown id");
    }

    public EngineGround getEngineByExternalId(String externalId) throws Exception {
        List<EngineGround> engines = this.getEngines();
        for (EngineGround engineGround : engines) {
            if (engineGround.getExternalId() == null || !engineGround.getExternalId().equals(externalId)) continue;
            return engineGround;
        }
        throw new Exception("Unknown external id");
    }

    private EngineGround constructInfo(File engineRoot) throws Exception {
        File file = new File(engineRoot, "engine.xml");
        if (!file.exists()) {
            return null;
        }
        Element node = DOMUtils.parseFile((String)file.getAbsolutePath()).getDocumentElement();
        EngineGround newEngineInfo = new EngineGround(this);
        newEngineInfo.loadFromXml(node);
        newEngineInfo.setFile(engineRoot);
        newEngineInfo.setPersistenceRoot(new File(engineRoot.getParentFile(), engineRoot.getName() + PERSISTENT_DIR_SUFFIX));
        return newEngineInfo;
    }

    public synchronized void deleteEngine(String engineId) {
        List<EngineGround> infos = this.getEngines();
        for (EngineGround engineInfo : infos) {
            if (!engineInfo.getEngineId().equals(engineId)) continue;
            FileUtils.deleteDir((File)engineInfo.getFile());
            if (engineInfo.getPersistenceRoot().exists() && !engineInfo.getPersistenceRoot().equals(this.getRoot())) {
                FileUtils.deleteDir((File)engineInfo.getPersistenceRoot());
            }
            return;
        }
    }

    public synchronized OperatingSystem getOperatingSystem() throws Exception {
        return OperatingSystemFactory.getCurrentOperatingSystem(this.provider);
    }

    public File getRoot() {
        return new File(this.provider.getSettings().getDeploymentsDir());
    }
}

