/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EngineLoggerRestartResponse;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.EngineStartProgress;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.MessageHandler;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.api.console.ConsoleReader;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.HttpUtils;
import com.browsersoft.config.utils.JavaVersionChecker;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEngineRun
implements EngineRun {
    private OperatingSystem operatingSystem;
    private EngineGround engineInfo;
    private MessageHandler messageHandler;
    private ConsoleReader consoleReader;
    private String lastMessageId = UUID.randomUUID().toString();
    private boolean shouldStop;
    private static final Logger log = LoggerFactory.getLogger(LocalEngineRun.class);

    public LocalEngineRun(OperatingSystem operatingSystem, EngineGround engineInfo) {
        this.operatingSystem = operatingSystem;
        this.engineInfo = engineInfo;
        this.consoleReader = new ConsoleReader(engineInfo.getFile());
    }

    @Override
    public void runEngine(List<Consumer<Process>> startListeners) throws Exception {
        if (!this.operatingSystem.isEngineRunning(this.engineInfo.getEngineId())) {
            ArrayList<Consumer<Process>> consumers = new ArrayList<Consumer<Process>>(this.engineInfo.getStartConsumers());
            if (startListeners != null) {
                consumers.addAll(startListeners);
            }
            log.info(this.operatingSystem.runEngine(this.engineInfo.getFile(), consumers));
        }
    }

    @Override
    public String getPid() {
        try {
            return this.operatingSystem.getPid(this.engineInfo.getEngineId());
        }
        catch (Exception e) {
            log.warn("Could not obtain PID for process " + this.engineInfo.getEngineId(), (Throwable)e);
            return "";
        }
    }

    @Override
    public void stopEngine(UserInfo userInfo) throws Exception {
        String url = this.getURL() + "/stop";
        if (userInfo == null) {
            HttpUtils.openURL((String)url, (boolean)false);
        } else {
            HttpUtils.sendBytes((String)url, (byte[])userInfo.getXml().getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public EngineLoggerRestartResponse restartLogger(UserInfo userInfo) throws Exception {
        String resultString;
        String url = this.getURL() + "/externalLoggerReset";
        try {
            resultString = HttpUtils.openURL((String)url, (boolean)false);
        }
        catch (IOException e) {
            return EngineLoggerRestartResponse.UNSUPPORTED;
        }
        if (resultString.equals("Logger reset")) {
            return EngineLoggerRestartResponse.OK;
        }
        return EngineLoggerRestartResponse.FAIL;
    }

    @Override
    public EngineStartProgress getProgress() {
        String url = this.getURL() + "/getProgress";
        try {
            String resultString = HttpUtils.openURL((String)url, (boolean)false);
            if (!resultString.equals("unknown")) {
                return new EngineStartProgress(resultString);
            }
        }
        catch (IOException e) {
            return new EngineStartProgress(0, "Stopped", "");
        }
        return null;
    }

    private String getURL() {
        return "http://localhost:" + this.engineInfo.getPort();
    }

    @Override
    public EngineProcessState getState() throws Exception {
        boolean running = this.operatingSystem.isEngineRunning(this.engineInfo.getEngineId());
        if (running) {
            String isStarted;
            try {
                isStarted = HttpUtils.openURL((String)(this.getURL() + "/isStarted"), (boolean)false);
            }
            catch (Exception e) {
                return EngineProcessState.STARTING;
            }
            if (isStarted.equals("true")) {
                return EngineProcessState.STARTED;
            }
            return EngineProcessState.STARTING;
        }
        return EngineProcessState.STOPPED;
    }

    @Override
    public void killEngine() throws Exception {
        this.operatingSystem.killEngine(this.engineInfo.getEngineId());
    }

    @Override
    public void deleteEngine() {
        this.finish();
        this.engineInfo.deleteEngine();
    }

    @Override
    public void executeEngineCommand(String command) throws Exception {
        this.operatingSystem.executeEngineCommand(this.engineInfo.getFile(), command);
    }

    @Override
    public List<Message> getConsole(String lastMessageId) throws Exception {
        return this.consoleReader.getConsole(lastMessageId);
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        return HttpUtils.sendBytes((String)(this.getURL() + "/handleStepRequest/" + boxId), (byte[])o);
    }

    @Override
    public void registerHandler(final MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!LocalEngineRun.this.shouldStop) {
                        List<Message> messages = LocalEngineRun.this.getConsole(LocalEngineRun.this.lastMessageId);
                        for (Message message : messages) {
                            messageHandler.message(message.getValue(), message.getType());
                            LocalEngineRun.this.lastMessageId = message.getId();
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception e) {
                    log.warn("", (Throwable)e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void finish() {
        this.shouldStop = true;
    }

    @Override
    public void backupData(String backupDestDirectory) throws Exception {
        File backupDir = new File(backupDestDirectory);
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        FileUtils.copyDirDeep((String)this.getRoot().getAbsolutePath(), (String)backupDestDirectory);
    }

    @Override
    public File getRoot() {
        return this.engineInfo.getFile();
    }

    @Override
    public byte[] readFile(String name) throws Exception {
        return this.engineInfo.readFile(name);
    }

    @Override
    public String getEngineId() {
        return this.engineInfo.getEngineId();
    }

    @Override
    public byte[] getJstack() throws Exception {
        String pid = this.operatingSystem.getPid(this.engineInfo.getEngineId());
        return this.operatingSystem.generateJstack(pid);
    }

    @Override
    public String checkRuntimeVersion() throws Exception {
        String releaseJavaVersion = this.engineInfo.getReleaseJavaVersion();
        String actualRuntimeVersion = this.engineInfo.getActualRuntimeVersion();
        String result = JavaVersionChecker.checkJavaVersion((String)actualRuntimeVersion, (String)releaseJavaVersion);
        if (Objects.equals(result, this.getJavaIgnore())) {
            return "";
        }
        return result;
    }

    private File getIgnoreFile() {
        File persistenceRoot = this.engineInfo.getPersistenceRoot();
        return new File(persistenceRoot.getAbsolutePath() + "/.javaIgnoreVersion");
    }

    private String getJavaIgnore() throws Exception {
        File f = this.getIgnoreFile();
        if (!f.exists()) {
            return "";
        }
        return FileUtils.loadFileToString((File)f).trim();
    }

    @Override
    public void confirmJavaVersion(String version) throws Exception {
        File ignoreFile = this.getIgnoreFile();
        if (!ignoreFile.exists() && !ignoreFile.createNewFile()) {
            throw new IOException("Could not create ignore file!");
        }
        if (version == null || version.isEmpty()) {
            return;
        }
        try (FileWriter myWriter = new FileWriter(ignoreFile);){
            myWriter.write(version);
        }
    }

    public void verifyRelease() throws Exception {
        String releaseName = this.engineInfo.getReleaseName();
        if (releaseName != null && !releaseName.isEmpty()) {
            this.operatingSystem.verifyRelease(this.engineInfo.getFile());
        }
    }
}

