/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineLoggerRestartResponse;
import com.browsersoft.config.api.EngineProcess;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.KubeNodeServiceProxy;
import com.browsersoft.config.api.KubeNodeServiceProxyWithDomain;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.jgate.exceptions.GateIOException;
import com.browsersoft.config.utils.StreamUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodEngineProcess
implements EngineProcess {
    private KubeNodeServiceProxy proxy;
    private String podId;
    private KubeNodeServiceProxyWithDomain proxyWithDomain;
    private static final Logger logger = LoggerFactory.getLogger(PodEngineProcess.class);
    private Map<Long, KubeNodeServiceProxy> proxiesByThreads = new HashMap<Long, KubeNodeServiceProxy>();

    public PodEngineProcess(KubeNodeServiceProxyWithDomain proxyWithDomain, String podId) {
        this.proxiesByThreads.put(Thread.currentThread().getId(), proxyWithDomain.getProxy());
        this.proxyWithDomain = proxyWithDomain;
        this.proxy = proxyWithDomain.getProxy();
        this.podId = podId;
    }

    @Override
    public String getConsole() {
        try {
            List<Message> messages = this.proxy.readPodConsole(this.podId, "");
            StringBuilder builder = new StringBuilder();
            for (Message m : messages) {
                builder.append(m).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            return StreamUtils.getExceptionStack((Throwable)e);
        }
    }

    @Override
    public String getPid() throws Exception {
        return "";
    }

    @Override
    public List<Message> getConsole(String lastMessageId) throws Exception {
        return this.proxy.readPodConsole(this.podId, lastMessageId);
    }

    @Override
    public EngineProcessState getState() {
        try {
            return this.proxy.getState(this.podId);
        }
        catch (Exception e) {
            return EngineProcessState.STOPPED;
        }
    }

    @Override
    public void stopProcess(UserInfo userInfo) throws Exception {
        try {
            this.proxy.stopPod(this.podId, userInfo);
        }
        catch (Exception e) {
            throw this.handleGateException(e);
        }
    }

    @Override
    public byte[] getJstack() throws Exception {
        return new byte[0];
    }

    @Override
    public void startProcess(UserInfo userInfo, List<Consumer<Process>> startConsumers) throws Exception {
    }

    @Override
    public void restartProcess(UserInfo userInfo) throws Exception {
    }

    @Override
    public void killProcess(UserInfo userInfo) throws Exception {
        try {
            this.proxy.killEngine(this.podId, userInfo);
        }
        catch (Exception e) {
            throw this.handleGateException(e);
        }
    }

    @Override
    public void executeEngineCommand(String command) throws Exception {
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        long id = Thread.currentThread().getId();
        KubeNodeServiceProxy proxy = this.proxiesByThreads.getOrDefault(id, null);
        if (proxy == null) {
            proxy = this.proxyWithDomain.constructNewProxy();
            this.proxiesByThreads.put(id, proxy);
        }
        try {
            return proxy.handleStepRequest(boxId, o, this.podId);
        }
        catch (Exception e) {
            throw this.handleGateException(e);
        }
    }

    @Override
    public byte[] readFile(String name) throws Exception {
        try {
            return this.proxy.readFile(this.podId, name);
        }
        catch (Exception e) {
            throw this.handleGateException(e);
        }
    }

    @Override
    public EngineLoggerRestartResponse restartLogger(UserInfo userInfo) throws Exception {
        try {
            this.proxy.restartLogger(this.podId, userInfo);
            return EngineLoggerRestartResponse.OK;
        }
        catch (Exception e) {
            throw this.handleGateException(e);
        }
    }

    private Exception handleGateException(Exception e) {
        logger.warn("", (Throwable)e);
        Exception ex = e;
        if (ex.getCause() == null || !(ex.getCause() instanceof GateIOException)) {
            return ex;
        }
        if ((ex = (Exception)ex.getCause()).getCause() == null || !(ex.getCause() instanceof InvocationTargetException)) {
            return ex;
        }
        if ((ex = (Exception)ex.getCause()).getCause() == null || !(ex.getCause() instanceof Exception)) {
            return ex;
        }
        return (Exception)ex.getCause();
    }

    @Override
    public void confirmRuntimeVersion(String version) throws Exception {
    }

    @Override
    public String checkRuntimeVersion() throws Exception {
        return "";
    }
}

