/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReleaseNotesTransferableFileStorage
implements Serializable,
TransferableFileStorage {
    private static final Lock lock = new ReentrantLock();
    private final File cacheDir;

    public ReleaseNotesTransferableFileStorage(File cacheDir) {
        this.cacheDir = cacheDir;
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
    }

    @Override
    public File put(TransferableFileInfo info, InputStream inputStream, ServiceCallMethodHandler handler) throws Exception {
        lock.lock();
        if (this.exists(info)) {
            lock.unlock();
            return this.get(info);
        }
        FileOutputStream tmpOutputStream = null;
        try {
            this.checkAndCreateCacheDir();
            File tmpFile = File.createTempFile("." + info.toCacheName(), ".tmp", this.cacheDir);
            tmpOutputStream = new FileOutputStream(tmpFile);
            if (!GateUtils.inputStreamToOutputStreamWithHandler((InputStream)inputStream, (OutputStream)tmpOutputStream, (ServiceCallMethodHandler)handler, (String)"", (long)((SizedInputStream)inputStream).getSize(), (int)10000)) {
                tmpOutputStream.close();
                tmpFile.delete();
                File file = null;
                return file;
            }
            tmpOutputStream.close();
            String xmlReleaseFile = info.toCacheName() + ".xml";
            File toFile = new File(this.cacheDir, xmlReleaseFile);
            if (!tmpFile.renameTo(toFile)) {
                throw new Exception("Error move " + tmpFile.getAbsolutePath() + " to " + toFile.getAbsolutePath());
            }
            tmpOutputStream = null;
            File file = toFile;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (tmpOutputStream != null) {
                try {
                    tmpOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            lock.unlock();
        }
    }

    private void checkAndCreateCacheDir() {
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    @Override
    public <T extends TransferableFileInfo> List<T> filter(List<T> items) throws Exception {
        ArrayList<TransferableFileInfo> ret = new ArrayList<TransferableFileInfo>();
        for (TransferableFileInfo item : items) {
            if (this.exists(item)) continue;
            ret.add(item);
        }
        return ret;
    }

    @Override
    public File get(TransferableFileInfo info) throws Exception {
        File xmlFile = this.getFile(info);
        if (!this.exists(info)) {
            return null;
        }
        return xmlFile;
    }

    @Override
    public boolean exists(TransferableFileInfo info) throws Exception {
        return this.getFile(info).exists();
    }

    private File getFile(TransferableFileInfo info) {
        return new File(this.cacheDir, info.toCacheName() + ".xml");
    }
}

