/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.Hash;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticTransferableFileStorage
implements Serializable,
TransferableFileStorage {
    private static final Lock lock = new ReentrantLock();
    private static final Logger log = LoggerFactory.getLogger(StaticTransferableFileStorage.class);
    private final File cacheDir;

    public StaticTransferableFileStorage(File cacheDir) {
        this.cacheDir = cacheDir;
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
    }

    @Override
    public File put(TransferableFileInfo info, InputStream inputStream, ServiceCallMethodHandler handler) throws Exception {
        lock.lock();
        try {
            if (this.exists(info)) {
                File file = this.get(info);
                return file;
            }
            File jarFile = this.getFile(info);
            this.checkAndCreateCacheDir();
            File tmpFile = File.createTempFile("." + info.toCacheName(), ".tmp", this.cacheDir);
            try (FileOutputStream tmpOutputStream = new FileOutputStream(tmpFile);){
                if (!GateUtils.inputStreamToOutputStreamWithHandler((InputStream)inputStream, (OutputStream)tmpOutputStream, (ServiceCallMethodHandler)handler, (String)"", (long)info.getSize(), (int)10000)) {
                    tmpFile.delete();
                    File file = null;
                    return file;
                }
            }
            String hash = Hash.toHex((byte[])Hash.forFile((File)tmpFile));
            if (!hash.equals(info.getHash())) {
                throw new Exception("Uploaded file hash differs (" + hash + "<>" + info.getHash() + ")!");
            }
            if (!tmpFile.renameTo(jarFile)) {
                throw new Exception("Error move " + tmpFile.getAbsolutePath() + " to " + jarFile.getAbsolutePath());
            }
            File file = jarFile;
            return file;
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    private void checkAndCreateCacheDir() {
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    @Override
    public <T extends TransferableFileInfo> List<T> filter(List<T> items) throws Exception {
        ArrayList<TransferableFileInfo> ret = new ArrayList<TransferableFileInfo>();
        for (TransferableFileInfo item : items) {
            if (this.exists(item)) continue;
            ret.add(item);
        }
        return ret;
    }

    @Override
    public File get(TransferableFileInfo info) throws Exception {
        File jarFile = this.getFile(info);
        if (!this.exists(info)) {
            return null;
        }
        return jarFile;
    }

    @Override
    public boolean exists(TransferableFileInfo info) throws Exception {
        File jarFile = this.getFile(info);
        if (this.getFile(info).exists()) {
            String hash = Hash.toHex((byte[])Hash.forByteArray((byte[])FileUtils.loadFileToBytes((File)jarFile.getAbsoluteFile())));
            if (!hash.equals(info.getHash())) {
                jarFile.delete();
                return false;
            }
            return true;
        }
        return false;
    }

    private File getFile(TransferableFileInfo info) {
        return new File(this.cacheDir, info.toCacheName() + ".jar");
    }
}

