/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineLoggerRestartResponse;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.EngineStartProgress;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.MessageHandler;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.utils.FileUtils;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncLocalEngineRun
implements EngineRun {
    private EngineRun engineRun;
    public static final int START_TIMEOUT = 240000;
    public static final int STOP_TIMEOUT = 40000;
    private static final Logger log = LoggerFactory.getLogger(SyncLocalEngineRun.class);

    public SyncLocalEngineRun(EngineRun engineRun) {
        this.engineRun = engineRun;
    }

    @Override
    public void runEngine(final List<Consumer<Process>> startListeners) throws Exception {
        Thread engineThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncLocalEngineRun.this.engineRun.runEngine(startListeners);
                }
                catch (Exception e) {
                    log.warn("Exception while running engine", (Throwable)e);
                }
            }
        }, "SyncLocalEngineRunThread::" + this.getEngineId());
        engineThread.setDaemon(true);
        engineThread.start();
        EngineProcessState engineProcessState = this.getState();
        long startAt = System.currentTimeMillis();
        while (engineProcessState != EngineProcessState.STARTED) {
            Thread.sleep(500L);
            if (System.currentTimeMillis() - startAt > 240000L) {
                throw new Exception("Timeout reach");
            }
            engineProcessState = this.getState();
        }
    }

    @Override
    public void stopEngine(UserInfo userInfo) throws Exception {
        this.engineRun.stopEngine(userInfo);
        EngineProcessState engineProcessState = this.getState();
        long startAt = System.currentTimeMillis();
        while (engineProcessState != EngineProcessState.STOPPED) {
            if (System.currentTimeMillis() - startAt > 40000L) {
                throw new Exception("Timeout reach");
            }
            Thread.sleep(500L);
            engineProcessState = this.getState();
        }
    }

    @Override
    public void killEngine() throws Exception {
        this.engineRun.killEngine();
        EngineProcessState engineProcessState = this.getState();
        long startAt = System.currentTimeMillis();
        while (engineProcessState != EngineProcessState.STOPPED) {
            if (System.currentTimeMillis() - startAt > 40000L) {
                throw new Exception("Timeout reach");
            }
            Thread.sleep(500L);
            engineProcessState = this.getState();
        }
    }

    @Override
    public void deleteEngine() {
        this.engineRun.deleteEngine();
    }

    @Override
    public void executeEngineCommand(String command) throws Exception {
        this.engineRun.executeEngineCommand(command);
    }

    @Override
    public EngineProcessState getState() throws Exception {
        return this.engineRun.getState();
    }

    @Override
    public String getPid() {
        return this.engineRun.getPid();
    }

    @Override
    public List<Message> getConsole(String lastMessageId) throws Exception {
        return this.engineRun.getConsole(lastMessageId);
    }

    @Override
    public void registerHandler(MessageHandler messageHandler) {
        this.engineRun.registerHandler(messageHandler);
    }

    @Override
    public void backupData(String backupDestDirectory) throws Exception {
        File backupDir = new File(backupDestDirectory);
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        FileUtils.copyDirDeep((String)this.getRoot().getAbsolutePath(), (String)backupDestDirectory);
    }

    @Override
    public void finish() {
        this.engineRun.finish();
    }

    @Override
    public File getRoot() {
        return this.engineRun.getRoot();
    }

    public byte[] handleStepRequest(String boxId, byte[] o) throws Exception {
        return this.engineRun.handleStepRequest(boxId, o);
    }

    @Override
    public byte[] readFile(String name) throws Exception {
        return this.engineRun.readFile(name);
    }

    @Override
    public String getEngineId() {
        return this.engineRun.getEngineId();
    }

    @Override
    public EngineLoggerRestartResponse restartLogger(UserInfo userInfo) throws Exception {
        return this.engineRun.restartLogger(userInfo);
    }

    @Override
    public EngineStartProgress getProgress() throws Exception {
        return this.engineRun.getProgress();
    }

    @Override
    public byte[] getJstack() throws Exception {
        return this.engineRun.getJstack();
    }

    @Override
    public String checkRuntimeVersion() throws Exception {
        return this.engineRun.checkRuntimeVersion();
    }

    @Override
    public void confirmJavaVersion(String version) throws Exception {
        this.engineRun.confirmJavaVersion(version);
    }
}

