/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.appinfo;

import com.browsersoft.config.api.appinfo.Jar;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.StreamUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Module {
    private final Map<String, Jar> jars = new LinkedHashMap<String, Jar>();

    private Module() {
    }

    public static Module fromXml(String xml) throws IOException, SAXException {
        Module fileInfoList = new Module();
        Element node = DOMUtils.loadFromString((String)xml).getDocumentElement();
        for (Node child : DOMUtils.getNodeChilds((Node)node, (String)"jar")) {
            String name = DOMUtils.getParameter((Node)child, (String)"name");
            long size = DOMUtils.getLongParameter((Node)child, (String)"size", (long)0L);
            String hash = DOMUtils.getParameter((Node)child, (String)"hash");
            fileInfoList.jars.put(name, new Jar(name, size, hash));
        }
        return fileInfoList;
    }

    public static Module fromXml(InputStream in) throws IOException, SAXException {
        byte[] xmlBytes = StreamUtils.loadInputStreamToBytes((InputStream)in);
        String xml = new String(xmlBytes, StandardCharsets.UTF_8);
        return Module.fromXml(xml);
    }

    public static Module fromXmlFile(String path) throws IOException, SAXException {
        byte[] xmlBytes;
        try (FileInputStream inputStream = new FileInputStream(path);){
            xmlBytes = StreamUtils.loadInputStreamToBytes((InputStream)inputStream);
        }
        String xml = new String(xmlBytes, StandardCharsets.UTF_8);
        return Module.fromXml(xml);
    }

    public Map<String, Jar> get() {
        return new LinkedHashMap<String, Jar>(this.jars);
    }
}

