/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.console;

import com.browsersoft.config.api.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReader {
    private static final String CONSOLE_FILE_NAME = "console";
    private File console1;
    private File console2;
    private File newerFile;
    private static final Logger log = LoggerFactory.getLogger(ConsoleReader.class);

    public ConsoleReader(File runDir) {
        this.initFiles(runDir);
    }

    public static void main(String[] args) throws Exception {
        String fileParentPath = "/Users/vmusil/workspace/hie-engine/run/";
        ConsoleReader consoleReader = new ConsoleReader(new File(fileParentPath));
        List<Message> out = consoleReader.getConsole("");
        log.info("" + out.size());
        out.forEach(msg -> log.info(msg.toString()));
    }

    public List<Message> getConsole(String lastMessageId) throws Exception {
        this.determineActiveFile();
        return this.readMessages(lastMessageId);
    }

    private void initFiles(File parentFile) {
        this.console1 = new File(parentFile, "console1.out");
        this.console2 = new File(parentFile, "console2.out");
    }

    private void determineActiveFile() {
        this.newerFile = !this.console1.exists() && !this.console2.exists() ? null : (this.console1.exists() && !this.console2.exists() ? this.console1 : (!this.console1.exists() && this.console2.exists() ? this.console2 : (this.console1.lastModified() > this.console2.lastModified() ? this.console1 : this.console2)));
    }

    private List<Message> readMessages(String lastMessageId) throws Exception {
        if (this.newerFile == null) {
            return new ArrayList<Message>();
        }
        if (lastMessageId == null || lastMessageId.trim().isEmpty()) {
            return this.getAllExistingMessages();
        }
        List<Message> messages = ConsoleReader.getMessagesFromFile(this.newerFile, lastMessageId, false);
        if (messages != null) {
            return messages;
        }
        File olderFile = this.getOlderFile();
        if (olderFile == null) {
            return ConsoleReader.getMessagesFromFile(this.newerFile, "", true);
        }
        messages = ConsoleReader.getMessagesFromFile(olderFile, lastMessageId, false);
        if (messages != null) {
            List<Message> newMessages = ConsoleReader.getMessagesFromFile(this.newerFile, lastMessageId, true);
            if (newMessages != null) {
                messages.addAll(newMessages);
            }
            return messages;
        }
        return this.getAllExistingMessages();
    }

    private List<Message> getAllExistingMessages() throws Exception {
        List<Message> newerMsgs;
        ArrayList<Message> messages = new ArrayList<Message>();
        List<Message> olderMsgs = ConsoleReader.getMessagesFromFile(this.getOlderFile(), "", true);
        if (olderMsgs != null) {
            messages.addAll(olderMsgs);
        }
        if ((newerMsgs = ConsoleReader.getMessagesFromFile(this.newerFile, "", true)) != null) {
            messages.addAll(newerMsgs);
        }
        return messages;
    }

    private File getOlderFile() {
        return this.newerFile == this.console1 ? this.console2 : this.console1;
    }

    private static List<Message> getMessagesFromFile(File file, String lastMessageId, boolean ignoreLastMessageId) throws Exception {
        int nextChar;
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        if (!ignoreLastMessageId && (lastMessageId == null || lastMessageId.trim().isEmpty())) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, "#-#&&#-#".length());
        ArrayList<Message> messages = new ArrayList<Message>();
        StringBuilder lineSB = new StringBuilder();
        boolean found = ignoreLastMessageId;
        while ((nextChar = pushbackInputStream.read()) >= 0) {
            if (nextChar == 35 && ConsoleReader.isMessage(pushbackInputStream, nextChar)) {
                String line = lineSB.toString();
                line = line.startsWith("\n") ? line.substring(1) : line;
                String[] s = line.split("-#@#-");
                Message message = new Message(s[0], s[1], s[2]);
                if (found) {
                    messages.add(message);
                } else if (line.startsWith(lastMessageId)) {
                    found = true;
                }
                lineSB = new StringBuilder();
                continue;
            }
            lineSB.append((char)nextChar);
        }
        fileInputStream.close();
        return found ? messages : null;
    }

    public static List<Message> parseMessages(String s) {
        String[] list;
        ArrayList<Message> ret = new ArrayList<Message>();
        for (String l : list = s.split("#-#&&#-#", -1)) {
            String[] parts = l.split("-#@#-", -1);
            String id = parts[0];
            String message = "";
            String type = "";
            if (parts.length > 1) {
                message = parts[1];
            } else if (parts.length > 2) {
                type = parts[2];
            }
            if (message.trim().equals("")) continue;
            ret.add(new Message(id, message, type));
        }
        return ret;
    }

    private static boolean isMessage(PushbackInputStream pushBackInputStream, int first) throws IOException {
        pushBackInputStream.unread(first);
        byte[] bytes = new byte["#-#&&#-#".length()];
        int ret = pushBackInputStream.read(bytes);
        if (ret == -1) {
            return false;
        }
        if (new String(bytes, "UTF-8").equals("#-#&&#-#")) {
            return true;
        }
        pushBackInputStream.unread(bytes, 1, "#-#&&#-#".length() - 1);
        return false;
    }
}

