/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.control;

import ch.qos.logback.classic.Level;
import com.browsersoft.config.api.AsyncEngineProcess;
import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.LocalEngineRun;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.api.UserInfoProvider;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemFactory;
import com.browsersoft.config.settings.InMemorySettings;
import com.browsersoft.config.settings.Settings;
import com.browsersoft.config.settings.SettingsProvider;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.JavaVersionChecker;
import com.browsersoft.config.utils.logger.ConfiguratorLoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlProcess {
    private static final Logger log = LoggerFactory.getLogger(ControlProcess.class);
    private static volatile boolean consoleKeepRunning = true;
    private static final String[] options = new String[]{"start", "stop", "kill", "status", "restart", "runCommand", "console", "loggerReset", "list", "getProgress"};

    public static void main(String[] args) throws Exception {
        CommandLine cmd = ControlProcess.handleArgs(args);
        String javaBinDir = cmd.getOptionValue("javaBinDir", "");
        String rootDir = cmd.getOptionValue("root", ".");
        String logLevel = cmd.getOptionValue("l", "INFO");
        String persistentRoot = cmd.getOptionValue("persistentRoot", ".");
        Level argLevel = Level.toLevel((String)logLevel, (Level)Level.WARN);
        ConfiguratorLoggerFactory loggerFactory = new ConfiguratorLoggerFactory();
        loggerFactory.init(argLevel, "%d{HH:mm:ss} [%p] - %m%n", true);
        String command = cmd.getArgs()[0];
        args = new String[cmd.getArgs().length - 1];
        System.arraycopy(cmd.getArgs(), 1, args, 0, args.length);
        File rootDirFile = new File(rootDir);
        EngineGround engineGround = new EngineGround(rootDirFile);
        engineGround.setPersistenceRoot(new File(persistentRoot));
        InMemorySettings settings = new InMemorySettings();
        settings.setJavaPath(javaBinDir);
        SettingsProvider settingsProvider = new SettingsProvider((Settings)settings);
        OperatingSystem operatingSystem = OperatingSystemFactory.getCurrentOperatingSystem(settingsProvider);
        LocalEngineRun localEngineRun = new LocalEngineRun(operatingSystem, engineGround);
        AsyncEngineProcess asyncEngineProcess = new AsyncEngineProcess(localEngineRun);
        if (command.equals("start")) {
            ControlProcess.checkRuntimeVersion(engineGround);
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.startProcess(userInfo);
            log.info("ok");
            while (asyncEngineProcess.getState() == EngineProcessState.STOPPED) {
                Thread.sleep(100L);
            }
            System.exit(0);
        } else if (command.equals("stop")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.stopProcess(userInfo);
            log.info("ok");
        } else if (command.equals("loggerReset")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.restartLogger(userInfo);
            log.info("ok");
        } else if (command.equals("kill")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.killProcess(userInfo);
            log.info("ok");
        } else if (command.equals("list")) {
            ControlProcess.runList(args);
        } else if (command.equals("restart")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.restartProcess(userInfo);
            while (asyncEngineProcess.getState() == EngineProcessState.STOPPED) {
                Thread.sleep(100L);
            }
            log.info("ok");
        } else if (command.equals("runCommand")) {
            ControlProcess.runCommand(localEngineRun, asyncEngineProcess, args);
        } else if (command.equals("console")) {
            ControlProcess.getConsole(asyncEngineProcess);
        } else if (command.equals("status")) {
            if (args.length > 0) {
                ControlProcess.checkProcessState(asyncEngineProcess, args[0]);
            } else {
                log.info(asyncEngineProcess.getState().toString());
            }
        } else if (command.equals("getProgress")) {
            System.out.println(localEngineRun.getProgress().toString());
        }
    }

    private static void checkRuntimeVersion(EngineGround engineGround) throws Exception {
        String ignoreVersionFileContent;
        log.info("Checking Runtime Version");
        File ignoreJavaVersionFile = new File(engineGround.getPersistenceRoot(), ".javaIgnoreVersion");
        String actualRuntimeVersion = engineGround.getActualRuntimeVersion();
        log.info("actualRuntimeVersion: {}", (Object)actualRuntimeVersion);
        if (actualRuntimeVersion == null || actualRuntimeVersion.isEmpty()) {
            actualRuntimeVersion = JavaVersionChecker.getJavaMajorVersion();
        }
        String releaseJavaVersion = engineGround.getReleaseJavaVersion();
        log.info("releaseJavaVersion: {}", (Object)releaseJavaVersion);
        if (actualRuntimeVersion.equals(releaseJavaVersion) || releaseJavaVersion == null || releaseJavaVersion.isEmpty()) {
            return;
        }
        for (String version : releaseJavaVersion.split(";")) {
            if (!version.equals(actualRuntimeVersion)) continue;
            return;
        }
        String ignorePermanentString = actualRuntimeVersion + ":" + releaseJavaVersion;
        if (ignoreJavaVersionFile.exists() && (ignoreVersionFileContent = FileUtils.loadFileToString((File)ignoreJavaVersionFile)).trim().equals(ignorePermanentString)) {
            return;
        }
        log.info("Using unsupported version");
        int ignoreJavaVersionResult = -1;
        try (Scanner scanner = new Scanner(System.in);){
            ignoreJavaVersionResult = ControlProcess.ignoreJavaVersion(scanner);
            if (ignoreJavaVersionResult == -1) {
                System.out.println("Stopping engine start due to unsupported Java version");
                System.exit(-1);
            }
        }
        File persistenceRoot = ignoreJavaVersionFile.getParentFile();
        if (!persistenceRoot.exists() && !persistenceRoot.mkdirs()) {
            log.warn("Could not create dirs in path {}", (Object)ignoreJavaVersionFile.getParentFile().getAbsolutePath());
        }
        log.info("Creating file {}", (Object)ignoreJavaVersionFile.getAbsolutePath());
        boolean newFile = ignoreJavaVersionFile.createNewFile();
        if (!newFile && !ignoreJavaVersionFile.exists()) {
            log.warn("Could not create {}", (Object)ignoreJavaVersionFile);
            log.warn("Stopping engine startup");
            System.exit(-1);
        }
        if (ignoreJavaVersionResult == 1) {
            try (FileOutputStream fos = new FileOutputStream(ignoreJavaVersionFile);){
                fos.write(ignorePermanentString.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static int ignoreJavaVersion(Scanner scanner) {
        String question = "You are using unsupported version of Java. Do you want to start engine anyways?\n(y)es - Ignore unsupported version ONCE\n(a)lways - Ignore unsupported version permanently\n(n)o - Stops start";
        System.out.println(question);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            switch (line.toLowerCase(Locale.ROOT)) {
                case "y": 
                case "yes": {
                    return 0;
                }
                case "n": 
                case "no": {
                    return -1;
                }
                case "a": 
                case "always": {
                    return 1;
                }
            }
            System.out.println(question);
        }
        return -1;
    }

    private static void checkProcessState(AsyncEngineProcess asyncEngineProcess, String expectedStateStr) throws Exception {
        EngineProcessState expectedState;
        switch (expectedStateStr) {
            case "starting": {
                expectedState = EngineProcessState.STARTING;
                break;
            }
            case "started": {
                expectedState = EngineProcessState.STARTED;
                break;
            }
            case "stopped": {
                expectedState = EngineProcessState.STOPPED;
                break;
            }
            default: {
                log.error("Unknown state: '{}'", (Object)expectedStateStr);
                System.exit(1);
                return;
            }
        }
        EngineProcessState state = asyncEngineProcess.getState();
        boolean res = state == expectedState;
        System.out.println(res ? "1" : "0");
        System.exit(res ? 0 : 1);
    }

    private static void runList(String[] args) {
        String SEPARATOR = "#&&#";
        File root = new File(args[0]);
        if (root.exists()) {
            for (File file : root.listFiles()) {
                Object out = file.isDirectory() ? "Y" : "N";
                out = (String)out + "#&&#";
                out = !file.isDirectory() ? (String)out + file.length() + "#&&#" : (String)out + "0#&&#";
                out = (String)out + file.lastModified() + "#&&#";
                out = (String)out + file.getName();
                System.out.println((String)out);
            }
        }
    }

    private static CommandLine handleArgs(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("j", "javaBinDir", true, "Path to java bin directory");
        options.addOption("r", "root", true, "Engine root");
        options.addOption("p", "persistentRoot", true, "Persistent root");
        options.addOption("h", "help", false, "Show this help");
        options.addOption("l", "loggerLevel", true, "Options: OFF, ERROR, WARN, INFO, DEBUG, TRACE, ALL");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        boolean optionFound = false;
        if (cmd.getArgs().length > 0) {
            String option = cmd.getArgs()[0];
            for (String allowedOption : ControlProcess.options) {
                if (!option.equals(allowedOption)) continue;
                optionFound = true;
            }
        }
        if (!optionFound || args.length == 0 || cmd.getArgs().length == 0 || cmd.hasOption("h")) {
            String usage = ControlProcess.class.getSimpleName() + " [options] ";
            usage = usage + "<";
            for (int i = 0; i < ControlProcess.options.length; ++i) {
                usage = usage + ControlProcess.options[i];
                if (i >= ControlProcess.options.length - 1) continue;
                usage = usage + "|";
            }
            usage = usage + ">";
            HelpFormatter formater = new HelpFormatter();
            formater.setOptionComparator(null);
            formater.printHelp(usage, options, false);
            System.exit(1);
        }
        return cmd;
    }

    private static void getConsole(AsyncEngineProcess asyncEngineProcess) throws Exception {
        String lastMessageId = "";
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                consoleKeepRunning = false;
            }
        });
        while (consoleKeepRunning) {
            List<Message> messages = asyncEngineProcess.getConsole(lastMessageId);
            for (Message message : messages) {
                lastMessageId = message.getId();
                log.info(message.getValue());
            }
            Thread.sleep(200L);
        }
    }

    private static void runCommand(LocalEngineRun localEngineRun, AsyncEngineProcess asyncEngineProcess, String[] args) throws Exception {
        localEngineRun.executeEngineCommand(ControlProcess.argumentsToString(args));
        List<Message> messages = asyncEngineProcess.getConsole("");
        for (Message message : messages) {
            log.info(message.getValue());
        }
    }

    private static String argumentsToString(String[] args) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            stringBuilder.append(args[i]);
            if (i == args.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

