/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.StreamUtils;
import com.browsersoft.config.utils.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;

public class ConfigDir
implements Serializable,
TransferableFileInfo {
    private String folderHash;
    private String name;
    private String type;
    private long size;
    private File sourceDir;
    private String sourceRecordHash;
    private String idInDeployment;
    private final boolean isZipped;

    public ConfigDir(File sourceDir, String name, String type, boolean isZipped) {
        this.sourceDir = sourceDir;
        this.name = name;
        this.type = type;
        this.isZipped = isZipped;
    }

    public ConfigDir(File sourceDir, String name, String type, String sourceRecordHash, boolean isZipped) {
        this.sourceDir = sourceDir;
        this.name = name;
        this.type = type;
        this.sourceRecordHash = sourceRecordHash;
        this.isZipped = isZipped;
    }

    public void beforeSerialization() throws Exception {
        byte[] bytes;
        if (this.isZipped) {
            try (FileInputStream in = new FileInputStream(this.sourceDir);){
                bytes = StreamUtils.loadInputStreamToBytes((InputStream)in);
            }
        } else {
            bytes = ZipUtil.zipDir((String)this.sourceDir.getAbsolutePath());
        }
        this.folderHash = Hash.toHex((byte[])Hash.forByteArray((byte[])bytes));
        this.size = bytes.length;
        this.sourceDir = null;
    }

    public boolean needDownload() {
        return this.sourceDir == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Override
    public String toCacheName() {
        return this.name + "-" + this.folderHash;
    }

    @Override
    public String getHash() {
        return this.folderHash;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getSourceRecordHash() {
        return this.sourceRecordHash;
    }

    public void setSourceRecordHash(String sourceRecordHash) {
        this.sourceRecordHash = sourceRecordHash;
    }

    public String getIdInDeployment() {
        return this.idInDeployment;
    }

    public void setIdInDeployment(String idInDeployment) {
        this.idInDeployment = idInDeployment;
    }

    public boolean isZipped() {
        return this.isZipped;
    }
}

