/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.ConfigItemLink;
import com.browsersoft.config.api.hub.ConfigItemRecordType;
import java.io.Serializable;

public class ConfigItemRecord
implements Serializable {
    private long id;
    private ConfigItemRecordType type;
    private String itemId;
    private String originalItemId;
    private String name;
    private String subType;
    private String value;
    private String additionalInfo1;
    private String additionalInfo2;
    private String additionalInfo3;
    private String additionalInfo4;
    private String additionalInfo5;
    private String additionalInfo6;
    private String parent;
    private String author;
    private String date;
    private boolean hasContent;
    private boolean sendNotification;
    private boolean broken;
    private String repositoryId;
    private String hash;
    private String copiedItemId;
    private String unchangedItemId;

    public ConfigItemRecord() {
    }

    public ConfigItemRecord(ConfigItemRecordType type) {
        this.type = type;
    }

    public ConfigItemRecord(ConfigItemRecordType type, String id) {
        this.type = type;
        this.itemId = id;
    }

    public ConfigItemRecord(String itemId, String name, ConfigItemRecordType type, String parent, boolean hasContent) {
        this.itemId = itemId;
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.hasContent = hasContent;
    }

    public ConfigItemRecord(String itemId, String name, ConfigItemRecordType type, String parent, boolean hasContent, String repositoryId) {
        this.itemId = itemId;
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.hasContent = hasContent;
        this.repositoryId = repositoryId;
    }

    public boolean isLinked() {
        return this.originalItemId != null && !this.originalItemId.equals("");
    }

    public boolean isExternal() {
        return this.getOriginalItemIdAsObject().isExternal();
    }

    public ConfigItemLink getOriginalItemIdAsObject() {
        return new ConfigItemLink(this.originalItemId);
    }

    public String getUnchangedItemId() {
        if (this.unchangedItemId != null) {
            return this.unchangedItemId;
        }
        return this.itemId;
    }

    public void resetUnchangedItemId() {
        this.unchangedItemId = null;
    }

    public boolean hasItemId() {
        if (this.itemId == null || this.itemId.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(this.itemId);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public ConfigItemRecordType getType() {
        return this.type;
    }

    public void setType(ConfigItemRecordType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String constructUniqueId() {
        return this.repositoryId + "#" + this.itemId;
    }

    public void setItemId(String itemId) {
        if (this.itemId != null && !this.itemId.isEmpty()) {
            this.unchangedItemId = this.itemId;
        }
        this.itemId = itemId;
    }

    public String getParent() {
        if (this.parent == null) {
            this.parent = "";
        }
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean hasContent() {
        if (this.type == null) {
            return false;
        }
        switch (this.type) {
            case ARCHITECTURE: 
            case RELEASE: {
                return true;
            }
        }
        return this.hasContent;
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ConfigItemRecord cloneRecord() {
        ConfigItemRecord record = new ConfigItemRecord();
        record.type = this.type;
        record.subType = this.subType;
        record.broken = this.broken;
        record.hasContent = this.hasContent;
        record.itemId = this.itemId;
        record.originalItemId = this.originalItemId;
        record.parent = this.parent;
        record.name = this.name;
        record.value = this.value;
        record.additionalInfo1 = this.additionalInfo1;
        record.additionalInfo2 = this.additionalInfo2;
        record.additionalInfo3 = this.additionalInfo3;
        record.additionalInfo4 = this.additionalInfo4;
        record.additionalInfo5 = this.additionalInfo5;
        record.additionalInfo6 = this.additionalInfo6;
        record.repositoryId = this.repositoryId;
        record.author = this.author;
        record.date = this.date;
        record.unchangedItemId = this.unchangedItemId;
        record.sendNotification = this.sendNotification;
        return record;
    }

    public String getAdditionalInfo1() {
        return this.additionalInfo1;
    }

    public void setAdditionalInfo1(String additionalInfo1) {
        this.additionalInfo1 = additionalInfo1;
    }

    public String getAdditionalInfo2() {
        return this.additionalInfo2;
    }

    public void setAdditionalInfo2(String additionalInfo2) {
        this.additionalInfo2 = additionalInfo2;
    }

    public String getAdditionalInfo3() {
        return this.additionalInfo3;
    }

    public void setAdditionalInfo3(String additionalInfo3) {
        this.additionalInfo3 = additionalInfo3;
    }

    public String getAdditionalInfo4() {
        return this.additionalInfo4;
    }

    public void setAdditionalInfo4(String additionalInfo4) {
        this.additionalInfo4 = additionalInfo4;
    }

    public String getAdditionalInfo5() {
        return this.additionalInfo5;
    }

    public void setAdditionalInfo5(String additionalInfo5) {
        this.additionalInfo5 = additionalInfo5;
    }

    public String getAdditionalInfo6() {
        return this.additionalInfo6;
    }

    public void setAdditionalInfo6(String additionalInfo6) {
        this.additionalInfo6 = additionalInfo6;
    }

    public String getOriginalItemId() {
        return this.originalItemId;
    }

    public void setOriginalItemId(String originalItemId) {
        this.originalItemId = originalItemId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String toKey() {
        return this.repositoryId + "-" + this.itemId;
    }

    public String toString() {
        return "ConfigItemRecord{id=" + this.id + ", type=" + this.type + ", itemId='" + this.itemId + "', originalItemId='" + this.originalItemId + "', name='" + this.name + "', subType='" + this.subType + "', value='" + this.value + "', additionalInfo1='" + this.additionalInfo1 + "', additionalInfo2='" + this.additionalInfo2 + "', additionalInfo3='" + this.additionalInfo3 + "', additionalInfo4='" + this.additionalInfo4 + "', additionalInfo5='" + this.additionalInfo5 + "', additionalInfo6='" + this.additionalInfo6 + "', hasContent=" + this.hasContent + ", parent='" + this.parent + "', broken=" + this.broken + ", repositoryId='" + this.repositoryId + "'}";
    }

    public int hashCode() {
        if (this.itemId != null && !this.itemId.isEmpty()) {
            return this.itemId.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigItemRecord) {
            ConfigItemRecord objRecord = (ConfigItemRecord)obj;
            if (this.itemId != null && objRecord.itemId != null) {
                return this.itemId.equals(objRecord.itemId);
            }
        }
        return super.equals(obj);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getCopiedItemId() {
        return this.copiedItemId;
    }

    public void setCopiedItemId(String copiedItemId) {
        this.copiedItemId = copiedItemId;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public boolean sendNotification() {
        return this.sendNotification;
    }

    public void setSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
    }
}

