/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.ConfigItemRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigItemsBulk
implements Serializable {
    private Map<String, List<ConfigItemRecord>> itemLists = new HashMap<String, List<ConfigItemRecord>>();
    private Map<String, ConfigItemRecord> items = new HashMap<String, ConfigItemRecord>();

    public List<List<ConfigItemRecord>> getLinksToOtherRepositories() {
        ArrayList<List<ConfigItemRecord>> ret = new ArrayList<List<ConfigItemRecord>>();
        for (List<ConfigItemRecord> path : this.itemLists.values()) {
            for (ConfigItemRecord record : path) {
                if (!record.isExternal()) continue;
                ret.add(this.createPath(record));
            }
        }
        return ret;
    }

    public void insertItems(List<ConfigItemRecord> path, List<ConfigItemRecord> response) {
        if (response != null) {
            ConfigItemRecord last = path.get(path.size() - 1);
            String key = last.toKey();
            this.insertItemList(response, key);
        }
    }

    public void setRepositoryIdToAll(String repositoryId) {
        for (List<ConfigItemRecord> list : this.itemLists.values()) {
            for (ConfigItemRecord record : list) {
                record.setRepositoryId(repositoryId);
            }
        }
        for (ConfigItemRecord entry : this.items.values()) {
            entry.setRepositoryId(repositoryId);
        }
    }

    private void insertItemList(List<ConfigItemRecord> response, String key) {
        if (!this.itemLists.containsKey(key)) {
            this.itemLists.put(key, response);
        }
    }

    public void insertItem(ConfigItemRecord response) {
        String key = response.toKey();
        this.insertItem(response, key);
    }

    private void insertItem(ConfigItemRecord response, String key) {
        if (!this.items.containsKey(key)) {
            this.items.put(key, response);
        }
    }

    public List<ConfigItemRecord> getItems(List<ConfigItemRecord> path) {
        if (path.size() == 0) {
            return null;
        }
        ConfigItemRecord last = path.get(path.size() - 1);
        String key = last.toKey();
        if (this.itemLists.containsKey(key)) {
            return this.itemLists.get(key);
        }
        return null;
    }

    public ConfigItemRecord getItem(ConfigItemRecord record) {
        String key = record.toKey();
        if (this.items.containsKey(key)) {
            return this.items.get(key);
        }
        return null;
    }

    public void add(ConfigItemsBulk bulk) {
        for (Map.Entry<String, List<ConfigItemRecord>> entry : bulk.getItemLists().entrySet()) {
            this.insertItemList(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : bulk.getItems().entrySet()) {
            this.insertItem((ConfigItemRecord)entry.getValue(), entry.getKey());
        }
    }

    public Map<String, List<ConfigItemRecord>> getItemLists() {
        return this.itemLists;
    }

    public Map<String, ConfigItemRecord> getItems() {
        return this.items;
    }

    private List<ConfigItemRecord> createPath(ConfigItemRecord record) {
        ArrayList<ConfigItemRecord> newPath = new ArrayList<ConfigItemRecord>();
        newPath.add(record);
        return newPath;
    }
}

