/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import java.io.Serializable;

public class ContainerImageURL
implements Serializable,
Cloneable {
    private static final String PROTO_DELIMITER = "://";
    private String registryUrl;
    private String repository;
    private String tag;

    public ContainerImageURL() {
    }

    public ContainerImageURL(String url) {
        this.parse(url);
    }

    private void parse(String url) {
        int repositoryIndex;
        if (url == null || url.isEmpty()) {
            return;
        }
        String localUrl = url;
        int protoIndex = localUrl.indexOf(PROTO_DELIMITER);
        int tagIndex = localUrl.lastIndexOf(":");
        if (tagIndex != -1 && (protoIndex == -1 || tagIndex > protoIndex)) {
            this.tag = localUrl.substring(tagIndex + 1);
            localUrl = localUrl.substring(0, tagIndex);
        }
        if ((repositoryIndex = localUrl.lastIndexOf("/")) != -1 && (protoIndex == -1 || repositoryIndex > protoIndex + PROTO_DELIMITER.length())) {
            this.repository = localUrl.substring(repositoryIndex + 1);
            localUrl = localUrl.substring(0, repositoryIndex);
        }
        this.registryUrl = localUrl;
    }

    public String toString() {
        Object ret = "";
        if (this.registryUrl != null) {
            ret = (String)ret + this.registryUrl;
        }
        if (this.repository != null) {
            if (!((String)ret).isEmpty() && !((String)ret).endsWith("/")) {
                ret = (String)ret + "/";
            }
            ret = (String)ret + this.repository;
            if (this.tag != null && !this.tag.isEmpty()) {
                ret = (String)ret + ":" + this.tag;
            }
        }
        return ret;
    }

    public ContainerImageURL clone() {
        ContainerImageURL clone = new ContainerImageURL();
        clone.registryUrl = this.registryUrl;
        clone.repository = this.repository;
        clone.tag = this.tag;
        return clone;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

