/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.HashException;
import java.io.File;
import java.io.Serializable;

public class JarRecord
implements Serializable,
TransferableFileInfo,
Cloneable {
    private long id;
    private String name;
    private String hash;
    private long size;
    private long releaseId;
    private File jarFile;

    public JarRecord clone() {
        JarRecord jarRecord = new JarRecord();
        jarRecord.id = this.id;
        jarRecord.name = this.name;
        jarRecord.hash = this.hash;
        jarRecord.size = this.size;
        jarRecord.releaseId = this.releaseId;
        jarRecord.jarFile = this.jarFile;
        return jarRecord;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(long releaseId) {
        this.releaseId = releaseId;
    }

    @Override
    public String toCacheName() {
        return this.name + "-" + this.hash;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFile) throws HashException {
        this.setJarFile(jarFile, true);
    }

    public void setHashFromDatabase(String hash) {
        this.hash = hash;
    }

    public void setFileSizeFromDatabase(long size) {
        this.size = size;
    }

    public void setJarFile(File jarFile, boolean computeAttributes) throws HashException {
        String hash = Hash.toHex((byte[])Hash.forFile((File)jarFile));
        this.jarFile = jarFile;
        if (computeAttributes) {
            this.name = jarFile.getName();
            this.size = jarFile.length();
            this.hash = hash;
        }
    }
}

