/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JdkInfo
implements Serializable {
    private final String jdkRelease;
    private final String numericVersion;
    private final String engineVersion;
    private final List<String> additionalVersions = new ArrayList<String>();

    public JdkInfo(String numericVersion, String jdkVersion, String engineVersion) {
        this.jdkRelease = jdkVersion;
        this.engineVersion = engineVersion;
        this.numericVersion = numericVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getJdkRelease() {
        return this.jdkRelease;
    }

    public String getNumericVersion() {
        return this.numericVersion;
    }

    public boolean addAdditionalVersion(String s) {
        return this.additionalVersions.add(s);
    }

    public List<String> getAdditionalVersions() {
        return this.additionalVersions;
    }

    public static JdkInfo getInfo(List<JdkInfo> infos, String numericVersion) {
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        for (JdkInfo info : infos) {
            if (!Objects.equals(info.getNumericVersion(), numericVersion)) continue;
            return info;
        }
        return null;
    }

    public List<JdkInfo> getAdditionalVersions(List<JdkInfo> infos) {
        if (infos.isEmpty() || this.additionalVersions.isEmpty()) {
            return List.of();
        }
        ArrayList<JdkInfo> resultList = new ArrayList<JdkInfo>();
        for (String additionalVersion : this.additionalVersions) {
            JdkInfo info = JdkInfo.getInfo(infos, additionalVersion);
            resultList.add(info);
        }
        return resultList;
    }
}

