/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.node;

import com.browsersoft.config.utils.DOMUtils;
import java.io.Serializable;
import java.util.StringJoiner;
import org.w3c.dom.Node;

public class InstallationSettings
implements Serializable {
    public static final String ROOT_ELEMENT_TAG = "installation";
    public static final String KEEP_ALIVE_ELEMENT_TAG = "keep-alive";
    public static final String GROUPS_ELEMENT_TAG = "groups";
    public static final String GROUPS_SEPARATOR = ",";
    private String name;
    private String groups = "";

    public InstallationSettings(String name) {
        this.name = name;
    }

    public static InstallationSettings fromXmlNode(Node node) {
        String groups = "";
        String name = DOMUtils.getParameter((Node)node, (String)"name");
        Node groupsNode = DOMUtils.getOneNodeChild((Node)node, (String)GROUPS_ELEMENT_TAG);
        if (groupsNode != null) {
            groups = DOMUtils.getTextContent((Node)groupsNode);
        }
        InstallationSettings settings = new InstallationSettings(name);
        settings.groups = groups;
        return settings;
    }

    public String toXml() {
        return "<installation name=\"" + this.name + "\">\n    <groups>" + this.groups + "</groups>\n</installation>";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        String[] groupsSplit = groups.split(GROUPS_SEPARATOR);
        StringJoiner sj = new StringJoiner(GROUPS_SEPARATOR);
        for (String s : groupsSplit) {
            sj.add(s.trim());
        }
        this.groups = sj.toString();
    }
}

