/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.node;

import com.browsersoft.config.api.node.KeepAliveSettingsKey;
import com.browsersoft.config.api.node.KeepAliveSettingsValue;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.HashException;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class KeepAliveSettings
implements Serializable {
    private final LinkedHashMap<KeepAliveSettingsKey, KeepAliveSettingsValue> valueMap;
    private final int keepAliveCheckInterval;
    private final boolean keepAliveCheckEnabled;
    private final boolean isAllKeepAliveActive;
    private final byte[] hash;

    public KeepAliveSettings(LinkedHashMap<KeepAliveSettingsKey, KeepAliveSettingsValue> valueMap, int checkInterval, boolean enabled, boolean isAllKeepAliveActive) throws IOException, HashException {
        this.valueMap = valueMap;
        this.keepAliveCheckInterval = checkInterval;
        this.keepAliveCheckEnabled = enabled;
        this.isAllKeepAliveActive = isAllKeepAliveActive;
        this.hash = Hash.forSerializable((Serializable)this);
    }

    public LinkedHashMap<KeepAliveSettingsKey, KeepAliveSettingsValue> getValueMap() {
        return this.valueMap;
    }

    public int getKeepAliveCheckInterval() {
        return this.keepAliveCheckInterval;
    }

    public boolean isKeepAliveCheckEnabled() {
        return this.keepAliveCheckEnabled;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean isAllKeepAliveActive() {
        return this.isAllKeepAliveActive;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeepAliveSettings)) {
            return false;
        }
        KeepAliveSettings that = (KeepAliveSettings)object;
        if (this.keepAliveCheckEnabled != that.isKeepAliveCheckEnabled()) {
            return false;
        }
        if (this.keepAliveCheckInterval != that.getKeepAliveCheckInterval()) {
            return false;
        }
        return this.valueMap.equals(that.valueMap);
    }
}

