/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.node;

import com.browsersoft.config.api.node.InstallationSettings;
import com.browsersoft.config.api.node.KeepAliveSettings;
import com.browsersoft.config.api.node.KeepAliveSettingsKey;
import com.browsersoft.config.api.node.KeepAliveSettingsValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeepAliveSettingsResolver {
    public static boolean isKeepAlive(String name, Map<String, InstallationSettings> installationSettingsMap, KeepAliveSettings keepAliveSettings) {
        List<Object> engineGroups = new ArrayList();
        if (installationSettingsMap.containsKey(name)) {
            InstallationSettings engineSettings = installationSettingsMap.get(name);
            String groups = engineSettings.getGroups();
            String[] split = groups.split(",");
            engineGroups = List.of(split);
        }
        KeepAliveSettingsKey key = new KeepAliveSettingsKey(name, KeepAliveSettingsKey.Type.ENGINE);
        KeepAliveSettingsValue engineValue = keepAliveSettings.getValueMap().getOrDefault(key, null);
        if (engineValue != null) {
            if (engineValue == KeepAliveSettingsValue.ENABLED) {
                return true;
            }
            if (engineValue == KeepAliveSettingsValue.DISABLED) {
                return false;
            }
        }
        boolean groupKeepAlive = false;
        for (String string : engineGroups) {
            KeepAliveSettingsKey groupKey = new KeepAliveSettingsKey(string, KeepAliveSettingsKey.Type.GROUP);
            KeepAliveSettingsValue groupValue = keepAliveSettings.getValueMap().get(groupKey);
            if (groupValue == null) continue;
            if (groupValue == KeepAliveSettingsValue.ENABLED) {
                groupKeepAlive = true;
            }
            if (groupValue != KeepAliveSettingsValue.DISABLED) continue;
            return false;
        }
        if (groupKeepAlive) {
            return true;
        }
        return keepAliveSettings.isAllKeepAliveActive();
    }
}

