/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.utils.HashException;
import com.browsersoft.config.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class BatchClassPathExtractor {
    public static List<JarRecord> getJars(File batchFile) throws IOException, HashException {
        String delimiter;
        String batch;
        try (FileInputStream inputStream = new FileInputStream(batchFile);){
            byte[] data = StreamUtils.loadInputStreamToBytes((InputStream)inputStream);
            batch = new String(data, StandardCharsets.UTF_8);
        }
        int index = batch.indexOf("-cp");
        if (index == -1) {
            throw new IOException("No classpath found in " + batchFile.getAbsolutePath());
        }
        String tmpData = batch.substring(index + 3).trim();
        String cpEnd = " com.browsersoft.medicalflow.MedicalBoxManager";
        index = tmpData.indexOf(cpEnd);
        tmpData = tmpData.substring(0, index);
        if (batchFile.getName().endsWith(".sh")) {
            delimiter = ":";
        } else if (batchFile.getName().endsWith(".bat")) {
            delimiter = ";";
        } else {
            throw new IOException("Unknown batch file type");
        }
        String[] paths = tmpData.split(delimiter);
        File deploymentDir = batchFile.getParentFile();
        ArrayList<JarRecord> ret = new ArrayList<JarRecord>();
        for (String path : paths) {
            if (path.startsWith("\"")) {
                path = path.substring(1);
            }
            if (path.endsWith("\"")) {
                path = path.substring(0, path.length() - 1);
            }
            File jarFile = Paths.get(path, new String[0]).isAbsolute() ? new File(path) : new File(deploymentDir, path).getAbsoluteFile();
            String jarName = jarFile.getName();
            index = jarName.indexOf(".jar");
            jarName = jarName.substring(0, index + 4);
            JarRecord jarRecord = new JarRecord();
            jarRecord.setJarFile(jarFile, true);
            jarRecord.setName(jarName);
            ret.add(jarRecord);
        }
        return ret;
    }
}

