/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.appinfo.Jar;
import com.browsersoft.config.api.appinfo.Module;
import com.browsersoft.config.api.deployment.RunScriptMacroReplacer;
import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.api.release.ReleaseVerificationException;
import com.browsersoft.config.api.release.ReleaseVerifier;
import com.browsersoft.config.api.system.BatchClassPathExtractor;
import com.browsersoft.config.api.system.JpsManager;
import com.browsersoft.config.api.system.UnixOperatingSystem;
import com.browsersoft.config.settings.Settings;
import com.browsersoft.config.settings.SettingsProvider;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.HashException;
import com.browsersoft.config.utils.RuntimeUtils;
import com.browsersoft.config.utils.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.xml.sax.SAXException;

public abstract class OperatingSystem {
    protected SettingsProvider settingsProvider;
    protected static final String WINDOWS_SCRIPT_START = "REM windows_script";
    protected static final String UNIX_SCRIPT_START = "#!/bin/sh";

    protected abstract String[] getCommandForKill(String var1);

    protected abstract String getClassPathSeparator();

    protected abstract String getExtensionForBatch();

    protected abstract String getArgumentPrefix();

    protected abstract String[] generateJstackCommand(String var1);

    public void init(SettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
        JpsManager.init(this.settingsProvider);
    }

    protected abstract String getStartScriptWithLocationCheck();

    protected abstract String getEndScriptWithLocationCheck();

    protected abstract String getScriptStart();

    public String getPid(String engineId) throws Exception {
        return this.findOutProcessId(engineId);
    }

    public void killEngine(String engineId) throws Exception {
        String processId = this.findOutProcessId(engineId);
        if (processId != null) {
            String[] command = this.getCommandForKill(processId);
            RuntimeUtils.runCmdSync((String[])command, null, (File)new File("."));
        }
    }

    public boolean isEngineRunning(String engineId) throws Exception {
        return this.findOutProcessId(engineId) != null;
    }

    private String findOutProcessId(String engineId) throws Exception {
        if (engineId == null) {
            return null;
        }
        return JpsManager.findEnginePid(engineId);
    }

    public boolean isUnix() {
        return this.getExtensionForBatch().equals("sh");
    }

    public void createScripts(String engineId, File destination, String root, String persistentRoot, List<String> files, boolean relative, String javaOpts, String programArgs) throws Exception {
        Settings settings = this.settingsProvider.getSettings();
        this.createRunScript(settings, destination, root, persistentRoot, engineId, javaOpts, files, programArgs);
        this.createHieEngineScript(settings, destination, persistentRoot);
        this.createEngineControl(destination);
    }

    protected void createRunScript(Settings settings, File destination, String root, String persistentRoot, String engineId, String additionalJavaOpts, List<String> files, String programArgs) throws Exception {
        String oracleLibraryDir = settings.getOracleLibraryPath();
        boolean crashEngineOnOutOfMemory = settings.getCrashEngineOnOutOfMemory();
        String java = this.buildJavaPath(settings);
        String javaOpts = this.buildJavaOpts(settings, additionalJavaOpts);
        String crashLogPath = persistentRoot + File.separator + "crash.log";
        StringBuilder stringBuilder = new StringBuilder();
        boolean isUnix = this.isUnix();
        stringBuilder.append(this.getScriptStart()).append("\n");
        if (isUnix) {
            stringBuilder.append("exec ");
        }
        stringBuilder.append(java).append(" ");
        if (!javaOpts.isEmpty()) {
            stringBuilder.append(javaOpts).append(" ");
        }
        if (crashEngineOnOutOfMemory) {
            stringBuilder.append("-XX:+CrashOnOutOfMemoryError").append(" ");
        }
        stringBuilder.append("-XX:ErrorFile=\"").append(crashLogPath).append("\"").append(" ");
        if (!javaOpts.contains("-Duser.timezone=")) {
            stringBuilder.append("-Duser.timezone=UTC").append(" ");
        }
        stringBuilder.append("-Djava.awt.headless=true");
        if (oracleLibraryDir != null) {
            stringBuilder.append(" -Djava.library.path=").append("\"").append(oracleLibraryDir).append("\"");
        }
        stringBuilder.append(" ").append("-cp").append(" ").append(this.createRelativeClassPath(destination, files)).append(" ").append("com.browsersoft.medicalflow.MedicalBoxManager").append(" ").append("\"").append(root).append("\"").append(" ").append("\"").append(persistentRoot).append("\"").append(" ").append("\"").append(engineId).append("\"");
        if (programArgs != null) {
            stringBuilder.append(" ").append(programArgs).append(" ");
        }
        if (isUnix) {
            stringBuilder.append(" $@");
        } else {
            stringBuilder.append(" %*");
        }
        String result = stringBuilder.toString();
        result = RunScriptMacroReplacer.replaceMacros(result, Map.of("%ROOT%", root, "%PERSISTENCE_ROOT%", persistentRoot));
        FileUtils.saveBytesToFile((File)new File(destination, "run." + this.getExtensionForBatch()), (byte[])result.getBytes());
    }

    public String createEngineControlCommand(String persistentRoot) throws IOException, SAXException {
        return this.createEngineControlCommand(this.settingsProvider.getSettings(), persistentRoot);
    }

    protected String createEngineControlCommand(Settings settings, String persistentRoot) throws IOException, SAXException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getScriptStart()).append("\n");
        stringBuilder.append(this.getStartScriptWithLocationCheck());
        String java = this.buildJavaPath(settings);
        stringBuilder.append(java).append(" ").append("-cp").append(" ");
        Collection<Jar> apiJars = this.getApiJars();
        Iterator<Jar> iterator = apiJars.iterator();
        while (iterator.hasNext()) {
            Jar jar = iterator.next();
            stringBuilder.append("engine_control/").append(jar.getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.getClassPathSeparator());
        }
        stringBuilder.append(" ").append("com.browsersoft.config.api.control.ControlProcess").append(" ");
        boolean isUnix = this.isUnix();
        if (isUnix) {
            stringBuilder.append("$@");
        } else {
            stringBuilder.append("%*");
        }
        stringBuilder.append(" -p \"").append(persistentRoot).append("\"");
        stringBuilder.append(this.getEndScriptWithLocationCheck());
        return stringBuilder.toString();
    }

    protected void createHieEngineScript(Settings settings, File destination, String persistentRoot) throws IOException, SAXException {
        String content = this.createEngineControlCommand(settings, persistentRoot);
        FileUtils.saveBytesToFile((File)new File(destination, "hieengine." + this.getExtensionForBatch()), (byte[])content.getBytes(StandardCharsets.UTF_8));
    }

    protected String buildJavaPath(Settings settings) {
        String javaBinDir = settings.getJavaPath();
        Object java = "java";
        if (javaBinDir != null && !javaBinDir.equals("")) {
            java = "\"" + new File(javaBinDir, "java").getAbsolutePath() + "\"";
        }
        return java;
    }

    protected String buildJavaOpts(Settings settings, String additionalJavaOpts) {
        String[] javaOptsArr = settings != null ? settings.getJavaOpts() : new String[]{};
        Object newJavaOpts = OperatingSystem.argumentsToString(javaOptsArr);
        if (newJavaOpts == null) {
            newJavaOpts = "";
        }
        if (additionalJavaOpts != null && !additionalJavaOpts.isEmpty()) {
            if (!((String)newJavaOpts).isEmpty()) {
                newJavaOpts = (String)newJavaOpts + " ";
            }
            newJavaOpts = (String)newJavaOpts + additionalJavaOpts;
        }
        return newJavaOpts;
    }

    public void createEngineControl(File destination) throws IOException, SAXException {
        File dir = new File(destination, "engine_control");
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("Unable to create directory '" + destination.getAbsolutePath() + "'");
        }
        Collection<Jar> apiJars = this.getApiJars();
        for (Jar jar : apiJars) {
            this.copyJar(dir, jar.getName());
        }
    }

    public Collection<Jar> getApiJars() throws IOException, SAXException {
        Module module;
        try (InputStream in = this.getClass().getResourceAsStream("/com/browsersoft/config/api/jars/api.xml");){
            module = Module.fromXml(in);
        }
        return module.get().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyJar(File root, String jarName) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = OperatingSystem.class.getResourceAsStream("/com/browsersoft/config/api/jars/" + jarName);
            if (inputStream == null) {
                throw new IOException("Can`t find jar " + jarName + " in the /com/browsersoft/config/api/jars/ path.Try to run publish-all ant task.");
            }
            outputStream = new FileOutputStream(new File(root, jarName));
            StreamUtils.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String runScript(File root, String name) throws Exception {
        return this.runScript(root, name, null);
    }

    public String runScript(File root, String name, String appendCmd) throws Exception {
        return this.runScript(root, name, appendCmd, null);
    }

    public String runScript(File root, String name, String appendCmd, List<Consumer<Process>> startConsumers) throws Exception {
        File file = new File(root, name);
        Object s = new String(FileUtils.loadFileToBytes((File)file), "UTF-8");
        if (((String)s).startsWith(UNIX_SCRIPT_START) || ((String)s).startsWith(WINDOWS_SCRIPT_START)) {
            s = "\"" + file.getAbsolutePath() + "\"";
        }
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        Settings settings = this.settingsProvider.getSettings();
        String oracleLibraryDir = settings.getOracleLibraryPath();
        String oracleDriverTimezone = settings.getOracleDriverTimezone();
        if (this instanceof UnixOperatingSystem && oracleLibraryDir != null && !oracleLibraryDir.isEmpty()) {
            String ldPath = env.getOrDefault("LD_LIBRARY_PATH", "");
            if (ldPath.isEmpty()) {
                env.put("LD_LIBRARY_PATH", oracleLibraryDir);
            } else if (!ldPath.contains(oracleLibraryDir)) {
                env.put("LD_LIBRARY_PATH", ldPath + ":" + oracleLibraryDir);
            }
        }
        if (this instanceof UnixOperatingSystem && oracleDriverTimezone != null && !oracleDriverTimezone.isEmpty()) {
            env.put("ORA_SDTZ", oracleDriverTimezone);
        }
        if (appendCmd != null && !appendCmd.isEmpty()) {
            s = (String)s + appendCmd;
        }
        return RuntimeUtils.runCmdSync((String)s, env, (File)root, startConsumers);
    }

    public String runScriptNatively(File root, String name) throws Exception {
        String[] command = new String[]{"./" + name};
        return RuntimeUtils.runCmdSync((String[])command, null, (File)root);
    }

    public String runEngine(File root, List<Consumer<Process>> consumers) throws Exception {
        return this.runScript(root, "./run." + this.getExtensionForBatch(), null, consumers);
    }

    public String executeEngineCommand(File root, String command) throws Exception {
        return this.runScript(root, "./run." + this.getExtensionForBatch(), " " + command);
    }

    public String createRelativeClassPath(File root, List<String> files) throws Exception {
        String oracleDriverPath = this.settingsProvider.getSettings().getOracleDriverPath();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = files.iterator();
        Path rootPath = Paths.get(root.getAbsolutePath(), new String[0]);
        while (iterator.hasNext()) {
            String file = iterator.next();
            Path filepath = Paths.get(file, new String[0]);
            String filename = filepath.getFileName().toString();
            if (oracleDriverPath != null && !oracleDriverPath.equals("") && filename.matches("^ojdbc\\d+.*$")) {
                stringBuilder.append("\"").append(oracleDriverPath).append("\"");
            } else if (this.haveAnyCommonAncestor(filepath, rootPath)) {
                String path = rootPath.relativize(filepath).toString();
                stringBuilder.append("\"").append(path.replace('\\', '/')).append("\"");
            } else {
                stringBuilder.append("\"").append(filepath.toFile().getAbsolutePath().replace('\\', '/')).append("\"");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.getClassPathSeparator());
        }
        return stringBuilder.toString();
    }

    private boolean haveAnyCommonAncestor(Path file1, Path file2) {
        if (file1.equals(file2)) {
            return true;
        }
        if (!Objects.equals(file1.getRoot(), file2.getRoot())) {
            return false;
        }
        return Objects.equals(file1.getName(0), file2.getName(0));
    }

    public void verifyRelease(File root) throws IOException, HashException, ReleaseVerificationException, SAXException, CertificateException {
        File batchFile = new File(root, "run." + this.getExtensionForBatch());
        List<JarRecord> jars = BatchClassPathExtractor.getJars(batchFile);
        ReleaseVerifier.verify(jars);
    }

    public static String argumentsToString(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            if (i >= args.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public byte[] generateJstack(String pid) throws IOException {
        String[] command = this.generateJstackCommand(pid);
        return RuntimeUtils.runCmdSync((String[])command, (File)new File(this.settingsProvider.getSettings().getDeploymentsDir())).getBytes(StandardCharsets.UTF_8);
    }
}

