/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemType;
import com.browsersoft.config.api.system.UnixOperatingSystem;
import com.browsersoft.config.api.system.WindowsOperatingSystem;
import com.browsersoft.config.settings.SettingsProvider;

public class OperatingSystemFactory {
    private static OperatingSystem currentOperatingSystem;

    public static OperatingSystem getOperatingSystem(OperatingSystemType type) throws Exception {
        OperatingSystem system;
        switch (type) {
            case Windows: {
                system = new WindowsOperatingSystem();
                break;
            }
            case Unix: {
                system = new UnixOperatingSystem();
                break;
            }
            default: {
                throw new Exception("Unknown operating system");
            }
        }
        system.init(new SettingsProvider());
        return system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperatingSystem getCurrentOperatingSystem(SettingsProvider settingsProvider) throws Exception {
        Class<OperatingSystemFactory> clazz = OperatingSystemFactory.class;
        synchronized (OperatingSystemFactory.class) {
            if (currentOperatingSystem == null) {
                OperatingSystem system;
                String osName = System.getProperty("os.name");
                String osNameMatch = osName.toLowerCase();
                if (osNameMatch.contains("linux")) {
                    system = new UnixOperatingSystem();
                } else if (osNameMatch.contains("windows")) {
                    system = new WindowsOperatingSystem();
                } else if (osNameMatch.contains("solaris") || osNameMatch.contains("sunos")) {
                    system = new UnixOperatingSystem();
                } else if (osNameMatch.contains("mac os") || osNameMatch.contains("macos") || osNameMatch.contains("darwin")) {
                    system = new UnixOperatingSystem();
                } else {
                    throw new Exception("Unsupported operating system");
                }
                system.init(settingsProvider);
                currentOperatingSystem = system;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return currentOperatingSystem;
        }
    }
}

