/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.system.OperatingSystem;
import java.io.File;
import java.util.List;

public class UnixOperatingSystem
extends OperatingSystem {
    @Override
    protected String[] getCommandForKill(String pid) {
        return new String[]{"kill", "-9", pid};
    }

    @Override
    protected String getClassPathSeparator() {
        return ":";
    }

    @Override
    protected String getExtensionForBatch() {
        return "sh";
    }

    @Override
    public void createScripts(String engineId, File destination, String root, String persistentRoot, List<String> files, boolean relative, String javaOpts, String programArgs) throws Exception {
        super.createScripts(engineId, destination, root, persistentRoot, files, relative, javaOpts, programArgs);
        new File(destination, "run.sh").setExecutable(true);
        new File(destination, "hieengine.sh").setExecutable(true);
    }

    @Override
    protected String[] generateJstackCommand(String pid) {
        File jstack = new File(this.settingsProvider.getSettings().getJavaPath(), "jstack");
        return new String[]{jstack.getAbsolutePath(), pid};
    }

    @Override
    protected String getScriptStart() {
        return "#!/bin/sh";
    }

    @Override
    protected String getStartScriptWithLocationCheck() {
        return "SCRIPT_PATH=$( cd -P -- \"$(dirname -- \"$0\")\" && pwd -P )\nPREVIOUS_PATH=$(pwd)\ncd \"$SCRIPT_PATH\"\n";
    }

    @Override
    protected String getEndScriptWithLocationCheck() {
        return "\ncd \"$PREVIOUS_PATH\"";
    }

    @Override
    protected String getArgumentPrefix() {
        return "$";
    }
}

