/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.system.OperatingSystem;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;

public class WindowsOperatingSystem
extends OperatingSystem {
    @Override
    protected String[] getCommandForKill(String pid) {
        return new String[]{"taskkill", "/pid", pid, "/f"};
    }

    @Override
    protected String getClassPathSeparator() {
        return ";";
    }

    @Override
    protected String getExtensionForBatch() {
        return "bat";
    }

    @Override
    protected String getArgumentPrefix() {
        return "%";
    }

    @Override
    public String runEngine(File root, List<Consumer<Process>> consumerList) throws Exception {
        return this.runScript(root, "run." + this.getExtensionForBatch());
    }

    @Override
    protected String[] generateJstackCommand(String pid) {
        File jstack = new File(this.settingsProvider.getSettings().getJavaPath(), "jstack.exe");
        return new String[]{jstack.getAbsolutePath(), pid};
    }

    @Override
    protected String getScriptStart() {
        return "REM windows_script";
    }

    @Override
    protected String getStartScriptWithLocationCheck() {
        return "@echo offsetlocal\nset \"batchDir=%~dp0\"\nfor %%I in (\"%batchDir%\") do set \"absolutePath=%%~fI\"\necho %absolutePath%\nset previousCd=%CD%\ncd %absolutePath%\n";
    }

    @Override
    protected String getEndScriptWithLocationCheck() {
        return "\ncd %previousCd%\nendlocal\n@echo on";
    }
}

