/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.update;

import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemFactory;
import com.browsersoft.config.api.system.WindowsOperatingSystem;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.settings.SettingsProvider;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;

public class UpdateUtils {
    public static void startUpdateVersion(File configUpdatePath) throws Exception {
        FileUtils.deleteDir((File)configUpdatePath);
        configUpdatePath.mkdir();
        File libsDir = new File(configUpdatePath, "libs");
        libsDir.mkdir();
    }

    public static void stopUpdateVersion(Map<String, String> files, File configUpdatePath, File configNodeRoot, Logger log) throws Exception {
        try {
            for (Map.Entry<String, String> entry : files.entrySet()) {
                String path = entry.getKey();
                String hash = entry.getValue();
                File file = new File(configUpdatePath, path);
                if (!file.exists()) {
                    throw new FileNotFoundException("Update file '" + path + "' not found!");
                }
                String fileHash = Hash.toHex((byte[])Hash.forFile((File)file));
                if (fileHash.equals(hash)) continue;
                throw new Exception("Update file hash '" + fileHash + "' differs from expected hash '" + hash + "'");
            }
        }
        catch (Exception e) {
            log.warn("Skipping update, error occurred during pre-check", (Throwable)e);
            UpdateUtils.skipUpdateVersion(configUpdatePath);
            throw e;
        }
        OperatingSystem os = OperatingSystemFactory.getCurrentOperatingSystem(new SettingsProvider());
        if (!(os instanceof WindowsOperatingSystem)) {
            os.runScriptNatively(configNodeRoot, "redeploy.sh");
        }
        System.exit(0);
    }

    public static void skipUpdateVersion(File configUpdatePath) throws Exception {
        FileUtils.deleteDir((File)configUpdatePath);
        configUpdatePath.mkdir();
    }

    public static void uploadUpdateFile(String path, String hash, SizedInputStream inputStream, File configUpdatePath, Logger log) throws Exception {
        boolean res;
        log.info("Receiving update file '" + path + "' [" + hash + "] of size " + inputStream.getSize());
        Path updatePath = configUpdatePath.toPath().normalize().toAbsolutePath();
        File destFile = new File(configUpdatePath, path);
        Path destPath = destFile.toPath().normalize().toAbsolutePath();
        if (!destPath.startsWith(updatePath)) {
            String msg = "Destination path '" + path + "' is outside allowed update path!";
            log.warn(msg);
            throw new Exception(msg);
        }
        File destDir = destFile.getParentFile();
        if (!destDir.exists() && !(res = destDir.mkdirs())) {
            String msg = "Unable to create directory '" + destDir.getAbsolutePath() + "'";
            log.warn(msg);
            throw new Exception(msg);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(destFile);){
            GateUtils.inputStreamToOutputStreamWithHandler((InputStream)inputStream, (OutputStream)fileOutputStream, null, (long)inputStream.getSize(), (int)1024);
            String fileHash = Hash.toHex((byte[])Hash.forFile((File)destFile));
            if (!fileHash.equals(hash)) {
                String msg = "Received file hash is different from stored file hash!";
                log.warn(msg);
                throw new Exception(msg);
            }
        }
        if (path.endsWith(".sh") && !(res = destFile.setExecutable(true))) {
            String msg = "Unable to set file '" + path + "' as executable";
            log.warn(msg);
            throw new Exception(msg);
        }
        log.info("Update file '" + destFile + "' successfully stored");
    }

    public static long getJarSize(String name, File configUpdatePath) throws Exception {
        File libsDir = new File(configUpdatePath, "libs");
        File file = new File(libsDir, name);
        if (!file.exists()) {
            return 0L;
        }
        return file.length();
    }
}

