/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.version;

import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.version.Version;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VersionParser {
    private static final Logger logger = LoggerFactory.getLogger(VersionParser.class);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ");
    private static VersionParser instance;
    private Node node;

    private VersionParser() {
        String resourceName = "com/browsersoft/config/version/version.xml";
        ClassLoader classLoader = VersionParser.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(resourceName);){
            if (inputStream == null) {
                this.node = null;
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            this.node = document.getDocumentElement();
        }
        catch (IOException e) {
            logger.warn("Error while reading version.xml ", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Parser configuration exception ", (Throwable)e);
        }
        catch (SAXException e) {
            logger.warn("Parser exception ", (Throwable)e);
        }
    }

    private static VersionParser getInstance() {
        if (instance == null) {
            instance = new VersionParser();
        }
        return instance;
    }

    public static Version getVersion() {
        Version v = new Version();
        VersionParser parser = VersionParser.getInstance();
        Node node = parser.node;
        if (node != null) {
            v.version = "82";
            v.gitVersion = DOMUtils.getParameter((Node)node, (String)"git-version", (String)"unknown");
            try {
                v.builtOn = dateFormat.parse(DOMUtils.getParameter((Node)node, (String)"build-on", (String)"1970-01-01T1:0:00+0100"));
            }
            catch (ParseException e) {
                logger.warn("Version date parsing exception", (Throwable)e);
            }
        }
        return v;
    }
}

