/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.console;

import com.browsersoft.config.console.ConsoleWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;

public class DefaultConsoleWriter
implements ConsoleWriter {
    private static final int BYTES_TO_MB = 0x100000;
    private FileOutputStream fileOutputStream;
    private boolean secondFileActive;
    private File firstOutput;
    private File secondOutput;
    private long alreadyWrittenMessages = 0L;
    private int maxMessagesPerFile = 1000;
    private int maxFileSizeInMB = -1;

    public DefaultConsoleWriter(File parent, String fileName) throws FileNotFoundException {
        this(parent, fileName, false);
    }

    public DefaultConsoleWriter(File parent, String fileName, boolean append) throws FileNotFoundException {
        this.firstOutput = new File(parent, fileName + "1.out");
        this.secondOutput = new File(parent, fileName + "2.out");
        if (!append) {
            if (this.firstOutput.exists()) {
                this.firstOutput.delete();
            }
            if (this.secondOutput.exists()) {
                this.secondOutput.delete();
            }
        }
        this.fileOutputStream = new FileOutputStream(this.determineActiveFile(), append);
    }

    private File determineActiveFile() {
        if (!this.firstOutput.exists() || !this.secondOutput.exists()) {
            return this.firstOutput;
        }
        if (new Date(this.firstOutput.lastModified()).after(new Date(this.secondOutput.lastModified()))) {
            return this.firstOutput;
        }
        this.secondFileActive = true;
        return this.secondOutput;
    }

    public void setMaxMessagesPerFile(int maxMessages) {
        if (this.maxFileSizeInMB < 1 && maxMessages < 1) {
            String errMsg = String.format("Max number of messages for the %s file must be higher positive value in case the file is not limited by size! The passed value(%d) will be ignored. Using the default(%d) value.", this.firstOutput.getName(), maxMessages, this.maxMessagesPerFile);
            return;
        }
        this.maxMessagesPerFile = maxMessages;
    }

    public void setMaxFileSizeInMB(int fileSizeInMB) {
        if (this.maxMessagesPerFile < 1 && fileSizeInMB < 1) {
            String errMsg = String.format("The max file size for the %s file must be higher positive value in case the file is not limited by number of messages! The passed value(%d) will be ignored. Using the default limitation by number of messages(%d).", this.firstOutput.getName(), fileSizeInMB, this.maxMessagesPerFile);
            return;
        }
        this.maxFileSizeInMB = fileSizeInMB;
    }

    @Override
    public synchronized void message(String message, String type) {
        try {
            byte[] bytes = (UUID.randomUUID().toString() + "-#@#-" + message + "-#@#-" + type + "#-#&&#-#\n").getBytes("UTF-8");
            this.fileOutputStream.write(bytes);
            this.fileOutputStream.flush();
            if (this.maxMessagesPerFile > 0 && ++this.alreadyWrittenMessages >= (long)this.maxMessagesPerFile || this.maxFileSizeInMB > 0 && this.fileSizeInMB() >= (long)this.maxFileSizeInMB) {
                this.switchFiles();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long fileSizeInMB() {
        return (this.secondFileActive ? this.secondOutput.length() : this.firstOutput.length()) / 0x100000L;
    }

    private void switchFiles() throws IOException {
        this.fileOutputStream.close();
        this.alreadyWrittenMessages = 0L;
        if (this.secondFileActive) {
            if (this.firstOutput.exists()) {
                this.firstOutput.delete();
            }
            this.fileOutputStream = new FileOutputStream(this.firstOutput);
        } else {
            if (this.secondOutput.exists()) {
                this.secondOutput.delete();
            }
            this.fileOutputStream = new FileOutputStream(this.secondOutput);
        }
        this.secondFileActive = !this.secondFileActive;
    }
}

