/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Cache<K, V> {
    private final Map<K, Item<V>> data = new HashMap<K, Item<V>>();
    private final long ttl;
    private final long clearInterval;
    private final Thread clearThread;

    public Cache(long ttl, String clearThreadName) {
        this(ttl, 5000L, clearThreadName);
    }

    public Cache(long ttl, long clearInterval, String clearThreadName) {
        this.ttl = ttl;
        this.clearInterval = clearInterval;
        this.clearThread = new Thread(this::clearThreadRun, clearThreadName);
        this.clearThread.setDaemon(true);
        this.clearThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Map<K, Item<V>> map = this.data;
        synchronized (map) {
            this.data.put(key, new Item<V>(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, Item<V>> map = this.data;
        synchronized (map) {
            this.data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Item<V> item;
        Map<K, Item<V>> map = this.data;
        synchronized (map) {
            item = this.data.get(key);
        }
        if (item != null && item.created > System.currentTimeMillis() - this.ttl) {
            return item.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearThreadRun() {
        while (true) {
            long start = System.currentTimeMillis();
            Map<K, Item<V>> map = this.data;
            synchronized (map) {
                long limit = System.currentTimeMillis() - this.ttl;
                Iterator<Map.Entry<K, Item<V>>> iterator = this.data.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, Item<V>> entry = iterator.next();
                    Item<V> item = entry.getValue();
                    if (item.created >= limit) continue;
                    iterator.remove();
                }
            }
            long next = start + this.clearInterval;
            long wait = next - System.currentTimeMillis();
            try {
                Thread.sleep(Math.max(wait, 0L));
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private static class Item<V> {
        public V value;
        public long created;

        public Item(V value) {
            this.value = value;
            this.created = System.currentTimeMillis();
        }
    }
}

