/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.util.concurrent.atomic.AtomicLong;

public class Cached<T> {
    private final AtomicLong timeout;
    private long created = 0L;
    private T data;

    public Cached(long timeoutInMs) {
        this(timeoutInMs, null);
    }

    public Cached(long timeoutInMs, T initial) {
        this.timeout = new AtomicLong(timeoutInMs);
        this.data = initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        Cached cached = this;
        synchronized (cached) {
            return this.created < System.currentTimeMillis() - this.timeout.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T data) {
        Cached cached = this;
        synchronized (cached) {
            this.created = System.currentTimeMillis();
            this.data = data;
        }
    }

    public void setTimeout(long newTimeout) {
        this.timeout.set(newTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Cached cached = this;
        synchronized (cached) {
            return this.data;
        }
    }
}

