/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Console {
    private final List<Message> messages = new ArrayList<Message>();
    private int capacity;

    public Console(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void message(String line) {
        if (this.messages.size() >= this.capacity) {
            this.messages.remove(0);
        }
        this.messages.add(new Message(null, line, ""));
    }

    public synchronized List<Message> lastMessages(String lastMessageId) {
        if (lastMessageId == null || lastMessageId.isEmpty()) {
            return this.allMessages();
        }
        int lastMessageIndex = -1;
        for (int i = 0; i < this.messages.size(); ++i) {
            if (!this.messages.get(i).getId().equals(lastMessageId)) continue;
            lastMessageIndex = i;
            break;
        }
        if (lastMessageIndex == -1) {
            return this.allMessages();
        }
        return this.messages.subList(lastMessageIndex + 1, this.messages.size());
    }

    public synchronized List<Message> allMessages() {
        return this.messages;
    }

    public synchronized void clear() {
        this.messages.clear();
    }

    public static String formattedMessages(List<Message> msgs) {
        StringBuilder sb = new StringBuilder();
        msgs.forEach(msg -> sb.append(msg.getValue()).append('\n'));
        return sb.toString();
    }

    public static class Message {
        private final String id;
        private final String value;
        private final String type;

        public Message(String id, String value, String type) {
            this.id = id == null || id.trim().isEmpty() ? UUID.randomUUID().toString() : id;
            this.value = value == null ? "" : value;
            this.type = type == null || type.equals("null") ? "" : type;
        }

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "Message{id='" + this.id + "', value='" + this.value + "', type='" + this.type + "'}";
        }
    }
}

