/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtils {
    public static List<Node> getNodeChilds(Node node, String name) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
                nodes.add(child);
            }
        }
        return nodes;
    }

    public static List<Node> getNodeChilds(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                nodes.add(child);
            }
        }
        return nodes;
    }

    public static Node getOneNodeChild(Node node, String name) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public static String getOneNodeChildTextContent(Node node, String name) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
                return DOMUtils.getTextContent(child);
            }
        }
        return "";
    }

    public static String removeRootTag(String xml) {
        if (xml == null || xml.trim().endsWith("/>")) {
            return "";
        }
        int start = xml.indexOf(">");
        int end = xml.lastIndexOf("<");
        return xml.substring(start + 1, end);
    }

    public static String xmlToIndendedXml(String xmlToIndent, boolean omitXmlDeclaration, int indent) throws Exception {
        Document doc = DOMUtils.loadFromString(xmlToIndent);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        return out.toString();
    }

    public static String nodetoXML(Node document, boolean indent) {
        return DOMUtils.nodetoXML(document, indent, false);
    }

    public static String nodetoXML(Node document, boolean indent, boolean withoutHeader) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", indent ? "yes" : "no");
            transformer.setOutputProperty("omit-xml-declaration", withoutHeader ? "yes" : "no");
            DOMSource source = new DOMSource(document);
            StringWriter h = new StringWriter();
            StreamResult result = new StreamResult(h);
            transformer.transform(source, result);
            return h.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getInnerNodeXml(Node node) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 3) {
                stringBuilder.append(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() != 1) continue;
            stringBuilder.append(DOMUtils.nodeXML(child));
        }
        return stringBuilder.toString();
    }

    public static String nodeXML(Node node) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(node);
        StringWriter h = new StringWriter();
        StreamResult result = new StreamResult(h);
        transformer.transform(source, result);
        return h.toString();
    }

    public static String nodetoXML(Node document) {
        return DOMUtils.nodetoXML(document, false);
    }

    public static String removeXMLHeader(String sXML) {
        int beginindex = sXML.indexOf("<?");
        int endindex = sXML.indexOf("?>");
        if (beginindex != -1 && endindex != -1) {
            sXML = sXML.substring(endindex + 2);
        }
        return sXML;
    }

    public static String nodetoXMLWithoutHeader(Node document) {
        return DOMUtils.nodetoXMLWithoutHeader(document, false);
    }

    public static String nodetoXMLWithoutHeader(Node document, boolean indent) {
        try {
            return DOMUtils.nodetoXML(document, indent, true);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Document parseFile(String sPath) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        parser.parse(sPath);
        return parser.getDocument();
    }

    public static Document loadFromString(String XML) throws IOException, SAXException {
        return DOMUtils.loadFromInputStream(new ByteArrayInputStream(XML.getBytes("UTF-8")), "UTF-8");
    }

    public static Document loadFromInputStream(InputStream inputStream, String encoding) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        InputSource mS = new InputSource(inputStream);
        if (encoding != null) {
            mS.setEncoding(encoding);
        }
        parser.parse(mS);
        return parser.getDocument();
    }

    public static Document loadFromInputStream(InputStream inputStream) throws IOException, SAXException {
        return DOMUtils.loadFromInputStream(inputStream, null);
    }

    public static String loadFileToStringWithReadEncoding(String sFile) throws Exception {
        String strfile = DOMUtils.loadFileToString(sFile);
        String encoding = DOMUtils.getEncoding(strfile);
        return DOMUtils.loadFileToStringWithEncoding(sFile, encoding);
    }

    public static String getEncoding(String sDocument) {
        int beginindex = sDocument.indexOf("<?");
        int endindex = sDocument.indexOf("?>");
        if (beginindex != -1 && endindex != -1) {
            sDocument = sDocument.substring(beginindex + 2, endindex);
            sDocument = sDocument.replace('\'', '\"');
            String[] aDoc = sDocument.split("\"");
            for (int i = 0; i < aDoc.length; ++i) {
                aDoc[i] = aDoc[i].trim();
                if (!aDoc[i].equalsIgnoreCase("encoding=") || i >= aDoc.length - 1) continue;
                return aDoc[i + 1].trim();
            }
        }
        return "";
    }

    public static String loadInputStreamToStringWithEncoding(InputStream stream, String encoding) throws Exception {
        int nums;
        byte[] buffer = new byte[1000];
        StringBuffer out = new StringBuffer();
        while ((nums = stream.read(buffer)) > 0) {
            String next = new String(buffer, 0, nums, encoding);
            out.append(next);
        }
        return out.toString();
    }

    public static String loadFileToStringWithEncoding(String sFile, String encoding) throws Exception {
        int nums;
        byte[] buffer = new byte[1000];
        StringBuffer out = new StringBuffer();
        FileInputStream stream = new FileInputStream(sFile);
        while ((nums = stream.read(buffer)) > 0) {
            String next = new String(buffer, 0, nums, encoding);
            out.append(next);
        }
        return out.toString();
    }

    public static String loadFileToString(String sFile) throws Exception {
        String s;
        BufferedReader in = new BufferedReader(new FileReader(sFile));
        StringBuffer out = new StringBuffer();
        while ((s = in.readLine()) != null) {
            out.append(s);
            out.append('\n');
        }
        return out.toString();
    }

    public static String getCDATATextContent(Node node) {
        NodeList children = node.getChildNodes();
        Object ret = "";
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 4) continue;
                ret = (String)ret + children.item(i).getNodeValue();
            }
        }
        return ((String)ret).trim();
    }

    public static String getTextContent(Node node) {
        NodeList children = node.getChildNodes();
        Object ret = "";
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 3) continue;
                ret = (String)ret + children.item(i).getNodeValue();
            }
        }
        return ((String)ret).trim();
    }

    public static String getTextContentNoTrim(Node node) {
        NodeList children = node.getChildNodes();
        Object ret = "";
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 3) continue;
                ret = (String)ret + children.item(i).getNodeValue();
            }
        }
        return ret;
    }

    public static String getTextContentOneLine(Node node) {
        String ret = DOMUtils.getTextContent(node);
        ret = ret.replace('\n', ' ');
        ret = ret.replace('\r', ' ');
        ret = ret.replace('\t', ' ');
        return ret;
    }

    public static String getTextContentComplete(Node node) {
        NodeList children = node.getChildNodes();
        Object ret = "";
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                ret = children.item(i).getNodeType() == 3 ? (String)ret + children.item(i).getNodeValue() : (String)ret + DOMUtils.getTextContentComplete(children.item(i));
            }
        }
        return ((String)ret).trim();
    }

    public static Node getFirstChildElement(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                return children.item(i);
            }
        }
        return null;
    }

    public static Color getColorParameter(Node node, String name, Color defaultValue) {
        return DOMUtils.getColorFromHTMLString(DOMUtils.getParameter(node, name), defaultValue);
    }

    public static Color getColorFromHTMLString(String sColor, Color defaultValue) {
        try {
            if (sColor.length() == 6) {
                return new Color(Integer.parseInt(sColor.substring(0, 2), 16), Integer.parseInt(sColor.substring(2, 4), 16), Integer.parseInt(sColor.substring(4, 6), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static int getIntParameter(Node node, String name, int defaultValue) {
        String value = DOMUtils.getParameter(node, name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long getLongParameter(Node node, String name, long defaultValue) {
        String value = DOMUtils.getParameter(node, name);
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static boolean getBooleanParameter(Node node, String name) {
        String value = DOMUtils.getParameter(node, name);
        return value != null && (value.equalsIgnoreCase("YES") || value.equalsIgnoreCase("TRUE"));
    }

    public static boolean getBooleanParameter(Node node, String name, boolean defaultValue) {
        String value = DOMUtils.getParameter(node, name);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String getParameter(Node node, String name) {
        return DOMUtils.getParameter(node, name, "");
    }

    public static String getParameter(Node node, String name, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Node attribute = attributes.getNamedItem(name);
            if (attribute != null) {
                return attribute.getNodeValue().trim();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static List<String> getCommaSeparatedListStringParameter(Node node, String name) {
        return DOMUtils.getCommaSeparatedListStringParameter(node, name, Collections.emptyList());
    }

    public static List<String> getCommaSeparatedListStringParameter(Node node, String name, List<String> defaultValue) {
        String[] strings;
        String value = DOMUtils.getParameter(node, name, null);
        if (value == null) {
            return defaultValue;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String v : strings = value.split(",")) {
            result.add(v.trim());
        }
        return result;
    }

    public static String stringToEntity(String string) {
        return DOMUtils.stringToEntity(string, false);
    }

    public static String stringToEntity(String string, boolean isHtml) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(string.length());
        try {
            DOMUtils.appendStringToEntity(string, isHtml, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void appendStringToEntity(String string, Appendable sb) throws IOException {
        if (string != null) {
            DOMUtils.appendStringToEntity(string, false, sb);
        }
    }

    public static void appendStringToEntity(String string, boolean isHtml, Appendable sb) throws IOException {
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            sb.append(DOMUtils.charToEntity(c, isHtml));
        }
    }

    public static String charToEntity(char c, boolean isHTML) {
        if (c == '\"') {
            return "&quot;";
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (!isHTML && c == '\'') {
            return "&apos;";
        }
        return String.valueOf(c);
    }

    public static String stringToNumberEntity(String string) {
        return DOMUtils.stringToNumberEntity(string, false);
    }

    public static String stringToNumberEntity(String string, boolean isHtml) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            sb.append(DOMUtils.charToNumberEntity(c, isHtml));
        }
        return sb.toString();
    }

    public static String charToNumberEntity(char c, boolean isHTML) {
        if (c == '\"') {
            return "&#34;";
        }
        if (c == '&') {
            return "&#38;";
        }
        if (c == '<') {
            return "&#60;";
        }
        if (c == '>') {
            return "&#62;";
        }
        if (!isHTML && c == '\'') {
            return "&#39;";
        }
        return String.valueOf(c);
    }

    public static String entityToString(String string) {
        if (string == null) {
            return "";
        }
        String res = string.replaceAll("&amp;", "&");
        res = res.replaceAll("&quot;", "\"");
        res = res.replaceAll("&lt;", "<");
        res = res.replaceAll("&gt;", ">");
        res = res.replaceAll("&apos;", "'");
        return res;
    }

    public static Map<String, String> getChildNodesAsParams(Node node) {
        HashMap<String, String> out = new HashMap<String, String>();
        List<Node> nodes = DOMUtils.getNodeChilds(node);
        for (Node child : nodes) {
            out.put(child.getNodeName(), DOMUtils.getTextContent(child));
        }
        return out;
    }

    public static List<Node> findTagsByName(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByName(node, tag, nodes);
        return nodes;
    }

    public static List<Node> findTagsByLocalName(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByLocalName(node, tag, nodes);
        return nodes;
    }

    public static List<Node> findTagsByLocalNameCaseSensitive(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByLocalNameCaseSensitive(node, tag, nodes);
        return nodes;
    }

    public static List<Node> findTagsByNameOneLevel(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByNameOnelevel(node, tag, nodes);
        return nodes;
    }

    public static Node findTagByNameOneLevel(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByNameOnelevel(node, tag, nodes);
        if (nodes.size() > 0) {
            return (Node)nodes.get(0);
        }
        return null;
    }

    public static Node findTagByName(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByName(node, tag, nodes);
        if (nodes.size() > 0) {
            return (Node)nodes.get(0);
        }
        return null;
    }

    public static Node findTagByLocalName(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByLocalName(node, tag, nodes);
        if (nodes.size() > 0) {
            return (Node)nodes.get(0);
        }
        return null;
    }

    public static List<Node> findTagsByNameCaseSensitive(Node node, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.findTagsByNameCaseSensitive(node, tag, nodes);
        return nodes;
    }

    public static void findTagsByName(Node node, String tag, List<Node> nodes) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equalsIgnoreCase(tag)) {
                nodes.add(child);
            }
            DOMUtils.findTagsByName(child, tag, nodes);
        }
    }

    public static List<Node> getAllNodes(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOMUtils.getAllNodes(node, nodes);
        return nodes;
    }

    public static void getAllNodes(Node node, List<Node> nodes) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            nodes.add(child);
            DOMUtils.getAllNodes(child, nodes);
        }
    }

    public static void findTagsByLocalName(Node node, String tag, List<Node> nodes) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getLocalName().equalsIgnoreCase(tag)) {
                nodes.add(child);
            }
            DOMUtils.findTagsByLocalName(child, tag, nodes);
        }
    }

    public static void findTagsByLocalNameCaseSensitive(Node node, String tag, List<Node> nodes) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getLocalName().equals(tag)) {
                nodes.add(child);
            }
            DOMUtils.findTagsByLocalNameCaseSensitive(child, tag, nodes);
        }
    }

    public static void findTagsByNameOnelevel(Node node, String tag, List<Node> nodes) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase(tag)) continue;
            nodes.add(child);
        }
    }

    public static void findTagsByNameCaseSensitive(Node node, String tag, List<Node> nodes) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals(tag)) {
                nodes.add(child);
            }
            DOMUtils.findTagsByNameCaseSensitive(child, tag, nodes);
        }
    }

    public static boolean xmlOverXsl(File xml, File xslt, File xmlout, String[] m_Parameters) throws Exception {
        StreamSource src = new StreamSource(xml);
        DOMUtils.xmlOverXsl(src, xslt, xmlout, m_Parameters);
        return true;
    }

    public static boolean xmlOverXsl(Source xml, File xslt, File xmlout, String[] m_Parameters) throws Exception {
        FileOutputStream out = new FileOutputStream(xmlout);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xslt));
        for (int i = 0; i < m_Parameters.length; i += 2) {
            transformer.setParameter(m_Parameters[i], m_Parameters[i + 1]);
        }
        StreamResult res = new StreamResult(out);
        transformer.transform(xml, res);
        return true;
    }

    public static String xmlOverXsl(String xml, String xslt, String[] m_Parameters) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(new StringReader(xslt)));
        for (int i = 0; i < m_Parameters.length; i += 2) {
            transformer.setParameter(m_Parameters[i], m_Parameters[i + 1]);
        }
        StreamResult res = new StreamResult(out);
        StreamSource inputSource = new StreamSource(new StringReader(xml));
        transformer.transform(inputSource, res);
        return new String(out.toByteArray(), "UTF-8");
    }

    public static String xmlOverXsl(String xml, String xslt) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(new StringReader(xslt)));
        StreamResult res = new StreamResult(out);
        StreamSource inputSource = new StreamSource(new StringReader(xml));
        transformer.transform(inputSource, res);
        return new String(out.toByteArray(), "UTF-8");
    }

    public static boolean isValidXML(String xml) {
        try {
            DOMUtils.loadFromString(xml);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String createPrefix(String previousPrefix, int counter) {
        if (previousPrefix.equals("")) {
            return counter + ".";
        }
        if (previousPrefix.endsWith(".")) {
            return previousPrefix + counter;
        }
        return previousPrefix + "." + counter;
    }

    public static String replaceTags(String taggedString) {
        String ret = taggedString;
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    public static String getTextContent(Node node, String childName) {
        Node defaultNode = DOMUtils.getOneNodeChild(node, childName);
        String value = "";
        if (defaultNode != null && (value = DOMUtils.getCDATATextContent(defaultNode)).equals("")) {
            value = DOMUtils.getTextContent(defaultNode);
        }
        return value;
    }
}

