/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    public static File getFile(File root, String ... pathItems) {
        File ret = root;
        for (String pathItem : pathItems) {
            ret = new File(ret, pathItem);
        }
        return ret;
    }

    public static void copyDirDeep(String sourceRoot, String targetRoot) throws Exception {
        FileUtils.copyDir(sourceRoot, targetRoot, "");
    }

    private static void copyDir(String sourceRoot, String targetRoot, String relativePath) throws Exception {
        File sourceDir = new File(sourceRoot + File.separatorChar + relativePath);
        for (String item : sourceDir.list()) {
            String newRelative = relativePath + File.separatorChar + item;
            File subSourceFile = new File(sourceRoot + File.separatorChar + newRelative);
            File subTargetFile = new File(targetRoot + File.separatorChar + newRelative);
            if (subSourceFile.isDirectory()) {
                subTargetFile.mkdir();
                FileUtils.copyDir(sourceRoot, targetRoot, newRelative);
                continue;
            }
            FileUtils.copyFile2File(subSourceFile, subTargetFile);
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteDirContent(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.deleteDir(new File(dir, children[i]));
            }
        }
    }

    public static byte[] loadFileToBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtils.inputStreamToOutputStream(fileInputStream, byteArrayOutputStream);
        fileInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void saveBytesToFile(File file, byte[] bytes) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtils.inputStreamToOutputStream(new ByteArrayInputStream(bytes), fileOutputStream);
        fileOutputStream.close();
    }

    public static boolean copyFile2File(File inputFile, File outputFile) throws Exception {
        byte[] buffer = new byte[2000];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        int m_length = 0;
        while ((m_length = in.read(buffer)) != -1) {
            out.write(buffer, 0, m_length);
        }
        out.close();
        in.close();
        return true;
    }

    public static List<File> getFilesWithExtensionInDirDeep(File root, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.getFilesWithExtensionRecursive(files, root, extension);
        return files;
    }

    private static void getFilesWithExtensionRecursive(List<File> files, File root, String extension) {
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.getFilesWithExtensionRecursive(files, file, extension);
                continue;
            }
            if (!FileUtils.getExtension(file.getName()).equals(extension)) continue;
            files.add(file);
        }
    }

    public static String loadFileToString(File sFile) throws Exception {
        String s;
        BufferedReader in = new BufferedReader(new FileReader(sFile));
        StringBuffer out = new StringBuffer();
        while ((s = in.readLine()) != null) {
            out.append(s);
            out.append('\n');
        }
        return out.toString();
    }

    public static String loadFileToOneLineString(File sFile) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(sFile));
        StringBuffer out = new StringBuffer();
        boolean isEscape = false;
        boolean isInString = false;
        boolean isComment = false;
        while ((line = in.readLine()) != null) {
            for (int i = 0; i < line.length(); ++i) {
                if (isEscape) {
                    isEscape = false;
                    continue;
                }
                if (line.charAt(i) == '\\') {
                    isEscape = true;
                    continue;
                }
                if (line.charAt(i) == '\"') {
                    isInString = !isInString;
                    continue;
                }
                if (isInString) continue;
                if (line.charAt(i) == '/') {
                    if (!isComment) {
                        isComment = true;
                        continue;
                    }
                    line = line.substring(0, i - 1);
                    isComment = false;
                    continue;
                }
                if (!isComment) continue;
                isComment = false;
            }
            if (!line.contains("catch")) {
                line = line.replaceAll("}", "};");
            }
            out.append(line);
        }
        line = out.toString();
        while (line.contains("  ")) {
            line = line.replaceAll("  ", " ");
        }
        line = line.replaceAll(">\\s+<", "> <");
        return line;
    }

    public static String loadFileToString(File file, String charset) throws IOException {
        String thisLine;
        InputStreamReader isReader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        BufferedReader bReader = new BufferedReader(isReader);
        StringBuffer result = new StringBuffer();
        while ((thisLine = bReader.readLine()) != null) {
            result.append(thisLine + "\n");
        }
        return result.toString();
    }

    public static String loadInputStreamToString(InputStream in, String charset) throws IOException {
        String thisLine;
        InputStreamReader isReader = new InputStreamReader(in, charset);
        BufferedReader bReader = new BufferedReader(isReader);
        StringBuffer result = new StringBuffer();
        while ((thisLine = bReader.readLine()) != null) {
            result.append(thisLine + "\n");
        }
        return result.toString();
    }

    public static String loadInputStreamToString(InputStream in, String charset, long offset, long length) throws IOException {
        int bufSize = length < 1024L ? (int)length : 1024;
        char[] buf = new char[bufSize];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        reader.skip(offset);
        while (true) {
            int num;
            if ((num = reader.read(buf)) > 0) {
                builder.append(buf, 0, num);
            }
            if (num < buf.length || (length -= (long)num) == 0L) break;
            if (length >= (long)buf.length) continue;
            buf = new char[(int)length];
        }
        return builder.toString();
    }

    public static void saveStringToFileWithEncoding(File file, String sStr, String encoding) throws Exception {
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(sStr.getBytes(encoding));
        }
    }

    public static String getFileNameWithoutExtension(String nameFile) {
        int start = nameFile.lastIndexOf(46);
        if (start > 0) {
            return nameFile.substring(0, start);
        }
        return nameFile;
    }

    public static String getJustFileNameFromPath(String nameFile) {
        int start = nameFile.lastIndexOf(47);
        if (start > 0) {
            return nameFile.substring(start + 1);
        }
        return nameFile;
    }

    public static String getExtension(String nameFile) {
        int start = nameFile.lastIndexOf(46);
        if (start > 0) {
            return nameFile.substring(start + 1);
        }
        return "";
    }

    public static InputStream getInputStream(String uri) throws IOException {
        if (uri.startsWith("file://")) {
            return new FileInputStream(uri.substring("file://".length()));
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + "9999)");
    }

    public static String getDirectoryFromURL(String url) {
        int start = url.lastIndexOf(47);
        if (start >= 0) {
            return url.substring(0, start + 1);
        }
        return url;
    }

    public static File ensureDirectory(String path) throws Exception {
        return FileUtils.ensureDirectory(new File(path));
    }

    public static File ensureDirectory(File directory) throws Exception {
        return FileUtils.ensureDirectory(directory, new String[0]);
    }

    public static File ensureDirectory(File parent, String ... path) throws Exception {
        boolean res;
        File dir = parent;
        if (path != null) {
            for (String name : path) {
                dir = new File(dir, name);
            }
        }
        if (!dir.exists() && !(res = dir.mkdirs())) {
            throw new Exception("Unable to create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    public static boolean isDirectoryEmpty(File directory) throws IOException {
        return FileUtils.isDirectoryEmpty(directory.toPath());
    }

    public static boolean isDirectoryEmpty(String path) throws IOException {
        return FileUtils.isDirectoryEmpty(Paths.get(path, new String[0]));
    }

    public static boolean isDirectoryEmpty(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directory = Files.newDirectoryStream(path);){
                boolean bl = !directory.iterator().hasNext();
                return bl;
            }
        }
        return false;
    }

    public static void createFile(File file, byte[] content, boolean executable) throws Exception {
        boolean res;
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(content);
        }
        if (executable && !(res = file.setExecutable(true))) {
            throw new Exception("Unable to set 'executable' flag for file '" + file.getAbsolutePath() + "'");
        }
    }
}

