/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.HashException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class Hash {
    public static final String ALGORITHM_MD5 = "md5";
    public static final String ALGORITHM_SHA1 = "sha1";
    public static final String ALGORITHM_DEFAULT = "sha1";

    public static byte[] forByteArray(byte[] bytes) throws HashException {
        return Hash.forByteArray(bytes, "sha1");
    }

    public static byte[] forSerializable(Serializable object) throws IOException, HashException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byte[] bytes = byteArrayOutputStream.toByteArray();
                byArray = Hash.forByteArray(bytes);
            }
            return byArray;
        }
    }

    public static byte[] forByteArray(byte[] bytes, String algorithm) throws HashException {
        try {
            MessageDigest m = MessageDigest.getInstance(algorithm);
            m.update(bytes, 0, bytes.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HashException("Could not generate hash from string", ex);
        }
    }

    public static byte[] forString(String s) throws HashException {
        return Hash.forString(s, "sha1");
    }

    public static byte[] forString(String s, String algorithm) throws HashException {
        try {
            MessageDigest m = MessageDigest.getInstance(algorithm);
            m.update(s.getBytes(), 0, s.length());
            return m.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HashException("Could not generate hash from string", ex);
        }
    }

    public static byte[] forFile(String filepath) throws HashException {
        return Hash.forFile(filepath, "sha1");
    }

    public static byte[] forFile(File file) throws HashException {
        return Hash.forFile(file, "sha1");
    }

    public static byte[] forFile(String filepath, String algorithm) throws HashException {
        return Hash.forFile(new File(filepath), algorithm);
    }

    public static byte[] forFile(File file, String algorithm) throws HashException {
        FileInputStream inputStream = null;
        try {
            int bytesRead;
            inputStream = new FileInputStream(file);
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] bytesBuffer = new byte[1024];
            while ((bytesRead = inputStream.read(bytesBuffer)) != -1) {
                digest.update(bytesBuffer, 0, bytesRead);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HashException("Could not generate hash from file", ex);
        }
        catch (IOException ex) {
            throw new HashException("Could not generate hash from file", ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] forDir(String dirpath, boolean includeHiddenFiles) throws HashException {
        return Hash.forDir(dirpath, includeHiddenFiles, "sha1");
    }

    public static byte[] forDir(File dir, boolean includeHiddenFiles) throws HashException {
        return Hash.forDir(dir, includeHiddenFiles, "sha1");
    }

    public static byte[] forDir(String dirpath, boolean includeHiddenFiles, String algorithm) throws HashException {
        return Hash.forDir(new File(dirpath), includeHiddenFiles, algorithm);
    }

    public static byte[] forDir(File dir, boolean includeHiddenFiles, String algorithm) throws HashException {
        if (!dir.isDirectory()) {
            throw new HashException("File '" + dir.getAbsolutePath() + "' is not directory!");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            Hash._forDirUpdateDigest(dir, includeHiddenFiles, digest);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HashException("Could not generate hash for file", ex);
        }
    }

    private static void _forDirUpdateDigest(File dir, boolean includeHiddenFiles, MessageDigest digest) throws HashException {
        File[] files = dir.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (File file : files) {
            if (!includeHiddenFiles && file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                Hash._forDirUpdateDigest(file, includeHiddenFiles, digest);
                continue;
            }
            FileInputStream inputStream = null;
            try {
                int bytesRead;
                inputStream = new FileInputStream(file);
                byte[] bytesBuffer = new byte[1024];
                while ((bytesRead = ((InputStream)inputStream).read(bytesBuffer)) != -1) {
                    digest.update(bytesBuffer, 0, bytesRead);
                }
            }
            catch (FileNotFoundException ex) {
                throw new HashException("Could not generate hash for directory", ex);
            }
            catch (IOException ex) {
                throw new HashException("Could not generate hash for directory", ex);
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static String toHex(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public static Map<String, String> getDirFilesHashes(File dir, boolean includeHiddenFiles, boolean deep) throws HashException {
        return Hash.getDirFilesHashes(dir, includeHiddenFiles, deep, null);
    }

    private static Map<String, String> getDirFilesHashes(File dir, boolean includeHiddenFiles, boolean deep, String prefix) throws HashException {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        File[] files = dir.listFiles();
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file : files) {
            if (!includeHiddenFiles && file.getName().startsWith(".")) continue;
            Object fileName = file.getName();
            if (prefix != null && !prefix.isEmpty()) {
                fileName = prefix + File.separator + (String)fileName;
            }
            if (deep && file.isDirectory()) {
                ret.putAll(Hash.getDirFilesHashes(file, includeHiddenFiles, deep, (String)fileName));
                continue;
            }
            ret.put((String)fileName, Hash.toHex(Hash.forFile(file)));
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 2) {
                if (args[0].equals("dir")) {
                    System.out.println("Dir sum: " + Hash.toHex(Hash.forDir(args[1], false)));
                } else if (args[0].equals("file")) {
                    System.out.println("File sum: " + Hash.toHex(Hash.forFile(args[1])));
                } else if (args[0].equals("string")) {
                    System.out.println("String sum: " + Hash.toHex(Hash.forString(args[1])));
                }
            } else {
                System.out.println("Usage: ./cmd <type> <path|data>");
            }
        }
        catch (HashException e) {
            System.out.println("Exception:");
            e.printStackTrace();
        }
    }
}

